#ifndef __AK9752_REG_H__
#define __AK9752_REG_H__

/**
 * Register Addresses for AK9752
 */
#define AK9752_REG_ADDR_WIA1        0x00        // Manufacturer ID
#define AK9752_REG_ADDR_WIA2        0x01        // Product ID
#define AK9752_REG_ADDR_INFO1       0x02        // AKM Internal Info
#define AK9752_REG_ADDR_INFO2       0x03        // AKM Internal Info
#define AK9752_REG_ADDR_ST1         0x04        // Status1: D0=DRDY 
#define AK9752_REG_ADDR_INTCAUSE    0x05        // Interrupt Cause: D4:D0=IRH,IRL,TMPH,TMPL,DR
#define AK9752_REG_ADDR_IRL         0x06        // IR Data, Low Byte
#define AK9752_REG_ADDR_IRH         0x07        // IR Data, High Byte
#define AK9752_REG_ADDR_TMPL        0x08        // Temperature Data, Low Byte
#define AK9752_REG_ADDR_TMPH        0x09        // Temperature Data, High Byte
#define AK9752_REG_ADDR_ST2         0x0A        // Status2: D0=DOR
#define AK9752_REG_ADDR_THIRHL      0x0B        // IR High Threshold, Low Byte
#define AK9752_REG_ADDR_THIRHH      0x0C        // IR High Threshold, High Byte
#define AK9752_REG_ADDR_THIRLL      0x0D        // IR Low Threshold, Low Byte
#define AK9752_REG_ADDR_THIRLH      0x0E        // IR Low Threshold, High Byte
#define AK9752_REG_ADDR_THTMPHL     0x0F        // Temp High Threshold, Low Byte
#define AK9752_REG_ADDR_THTMPHH     0x10        // Temp High Threshold, High Byte
#define AK9752_REG_ADDR_THTMPLL     0x11        // Temp Low Threshold, Low Byte
#define AK9752_REG_ADDR_THTMPLH     0x12        // Temp Low Threshold, High Byte
#define AK9752_REG_ADDR_INTEN       0x13        // Interrupt Enable: D4:D0=IRHI,IRLI,TMPHI,TMPLI,DRI
#define AK9752_REG_ADDR_CNTL1       0x14        // Frequency Cutoff Control: D4:D0=FCTMP[2:0],FCIR[1:0]
#define AK9752_REG_ADDR_CNTL2       0x15        // Operating Mode Control: D1:D0=MODE[1:0]
#define AK9752_REG_ADDR_CNTL3       0x16        // Soft Reset: D0=SRST

#define AK9752_REG_VALUE_WIA1       0x48        // Manufacturer Code (AKM)
#define AK9752_REG_VALUE_WIA2       0x14        // Product Code (AK9752)

#define AK9752_ST1_MASK_DRDY        0x01


#endif // __AK9752_REG_H__