#include "mbed.h"

#define WAIT_SOMEONE    0
#define NOT_ALONE       1

#define WAIT_MSG        0
#define MSG_RECIEVED    1

int status_RXmsg = MSG_RECIEVED;
int id_wait_repsonse = 0;

const unsigned int  TX_ID = 0x100;
 
Ticker ticker;
Timer t;

// Init CAN (1 from 2): 
//                 ( RD  ,  TD  , freq[hz])
//      1. CAN can(PA_11, PA_12, 1000000 );
//                 ( RD  ,  TD  )
//      2. CAN can(PA_11, PA_12);

CAN *can = new CAN(PA_11, PA_12, 1000000);
//CAN can(PB_8 , PB_9, 1000000); // NUCLEO-L476RG

// CAN messages
CANMessage txMsg;                 // create empty CAN message to transmit
CANMessage rxMsg;                 // create empty CAN recieved message

//USART
Serial pc(USBTX, USBRX);

char counter = 0;

int status = WAIT_SOMEONE;
int old_tderror = 0;
int new_tderror = 0;

int id_devices[10] = {0,0,0,0,0,0,0,0,0,0};
int device_counter = 0;

void init_can();
bool wait_response(int _id);

void printMsg(CANMessage& msg)
{
    pc.printf("  ID      = 0x%.3x\r\n", msg.id);
    pc.printf("  Type    = %d\r\n",     msg.type);
    pc.printf("  Format  = %d\r\n",     msg.format);
    pc.printf("  Length  = %d\r\n",     msg.len);
    pc.printf("  Data    =");
    for(int i = 0; i < msg.len; i++)
        //pc.printf(" 0x%.2X", msg.data[i]);
        pc.printf(" 0x%.2x", msg.data[i]);
    pc.printf("\r\n\n");
}

void onCanReceived(void)
{
    if(can->read(rxMsg)){
        int  new_id     = rxMsg.id;
        bool new_device = true;
        for(int i=0; i<=device_counter; i++){
            if (new_id == id_devices[i]) new_device = false;
        }
        if(new_device) {
            id_devices[device_counter] = new_id;
            device_counter++;
            pc.printf("New %dth device with ID %d have been added \r\n", device_counter, id_devices[device_counter-1]);
        }
        else{
            if (new_id == id_wait_repsonse){
                status_RXmsg = MSG_RECIEVED;
                //printMsg(rxMsg);
            }
        }
        if (device_counter != 0) status = NOT_ALONE;
    }
    else pc.printf("Read error!\r\n");
}

bool send(int _id, CANMessage _txMsg) {
    _txMsg.id = _id;
    new_tderror = can->tderror();
    if (new_tderror == 0 or new_tderror < old_tderror){
        if(can->write(CANMessage(_txMsg))) {
            //pc.printf("CAN rderror: %d, tderror: %d\r\n\n", can->rderror(), new_tderror );
        }
        old_tderror = new_tderror;
        return true;
    }
    else{
        pc.printf("CAN device with ID %d was lose\r\n", _id);
        old_tderror = new_tderror;
        return false;
    }
}
 
int main() {
    
    pc.baud(115200);
    
    init_can();
    
    
    
    while(1){
        while (status == NOT_ALONE){
            status = WAIT_SOMEONE;
            for(int i=0; i<device_counter; i++){
                if (id_devices[i] != 0){
                    t.reset();
                    t.start();
                    status_RXmsg = WAIT_MSG;
                    txMsg.data[0] = 0x02;       // Commande Discover
                    if(send(id_devices[i], txMsg)) {
                        if(wait_response(id_devices[i])) {
                            pc.printf("Not response\r\n");
                            id_devices[i] = 0;
                            //device_counter--;
                        }
                        else{
                            status = NOT_ALONE;
                            t.stop();
                            pc.printf("Device : %d \t Param_1 : %d \r\n", rxMsg.id, rxMsg.data[1]);
                            //pc.printf("Response time : %f [s] \r\n", t.read());
                            //pc.printf("%f send-read per 1ms  \r\n", 1/(t.read()*1000));
                        }
                    }
                    else { pc.printf("Not sent to Device %d\r\n", id_devices[i]);  }
                }
            }
            if (status == WAIT_SOMEONE) {
                device_counter = 0;
                pc.printf("ALL devices were disconnected! tderror = %d \r\n\n", new_tderror);
                delete can;
                can = new CAN(PA_11, PA_12, 1000000);
                pc.printf("After RESET CAN : tderror = %d \r\n\n", can->tderror());
                init_can();
                t.reset();
            }
            //wait_ms(1000);
        }
    }
}

void init_can(){
    // Change/set mode : (CAN::Normal, CAN::Silent, CAN::LocalTest, CAN::GlobalTest, CAN::SilentTest)
    can->mode(CAN::Normal);
    
    // Attach a function when message received
    can->attach(onCanReceived);
}

bool wait_response(int _id){
    id_wait_repsonse = _id;
    while(t.read() < 0.001){
        if (status_RXmsg == MSG_RECIEVED) return false;
    }
    return true;
}