#include "mbed.h"

#define WAIT_FREE_BUS   0
#define SHARE_BUS       1

const unsigned int  MY_ID = 63;
 
Ticker ticker;
Timer t;

// Init CAN (1 from 2): 
//                 ( RD  ,  TD  , freq[hz])
//      1. CAN can(PA_11, PA_12, 1000000 );
//                 ( RD  ,  TD  )
//      2. CAN can(PA_11, PA_12);

//CAN can(PA_11, PA_12); 
CAN *can= new CAN(PA_11, PA_12, 1000000);   // NUCLEO-L432KC
//CAN can(PB_8 , PB_9 ); // NUCLEO-L476RG

// CAN messages
CANMessage rxMsg;                 // create empty CAN recieved message
CANMessage txMsg;

//USART
Serial pc(USBTX, USBRX);

int counter = 0;
int status = WAIT_FREE_BUS;

int max_counter = 1;

void init_can();

void printMsg(CANMessage& msg)
{
    pc.printf("  ID      = 0x%.3x\r\n", msg.id);
    pc.printf("  Type    = %d\r\n",     msg.type);
    pc.printf("  Format  = %d\r\n",     msg.format);
    pc.printf("  Length  = %d\r\n",     msg.len);
    pc.printf("  Data    =");
    for(int i = 0; i < msg.len; i++)
        //pc.printf(" 0x%.2X", msg.data[i]);
        pc.printf(" %d", msg.data[i]);
    pc.printf("\r\n\n");
}

void send(CANMessage _txMsg) {
    if(can->write(_txMsg)) {
        //pc.printf("I said to server that I'm here\r\n");
        //pc.printf("CAN rderror: %d, tderror: %d\r\n\n", can->rderror(), can->tderror() );
    }
}

void onCanReceived(void)
{
    /*can->read(rxMsg);
    //pc.printf("counter == %d\r\n", counter);
    if(counter > max_counter-1){
        if (counter == max_counter){
            t.stop();
            status = 3;
            //pc.printf("%d packeges were send in period of %f seconds \r\n", counter, t.read());
            //pc.printf("%f packeges / second \r\n", counter / t.read());
            counter++;
        }
    }
    else{
        counter++;
        //pc.printf("-------------------------------------\r\n");
        //pc.printf("CAN message received\r\n");
        printMsg(rxMsg);
        if (rxMsg.data[0] == 0x02)  {
            pc.printf("I have to response!!! \r\n");
            send();
        }
    }*/
    if(can->read(rxMsg)){
        //printMsg(rxMsg);
        t.stop();
        t.reset();
        t.start();
        if (rxMsg.data[0] == 0x02)  {
            //pc.printf("I have to response!!! \r\n");
            txMsg.id = MY_ID;
            txMsg.data[0] = 0x01;       // Commande Retour de commande
            int type_Cmd = MY_ID;
            txMsg.data[1] = (type_Cmd >> 16);
            txMsg.data[2] = (type_Cmd-txMsg.data[1] >> 8);
            txMsg.data[3] = type_Cmd - (txMsg.data[2] << 8);
            send(txMsg);
        }
    }
}


int main() {
    
    pc.baud(115200);
    
    init_can();
    
    //ticker.attach(&send, 0.01);
    wait_ms(1000);
    t.start();
    while(1){
        pc.printf("I'm waiting free bus status \r\n");
        while(status == WAIT_FREE_BUS){
            //wait_ms(100);
            if(can->read(rxMsg)){
                pc.printf("There is some exchange \r\n");
            }
            else{
                //pc.printf("There is nobody. I'm starting to share the bus CAN \r\n");
                txMsg.id = MY_ID;
                txMsg.data[0] = 0x02;
                int type_Cmd = MY_ID;
                txMsg.data[1] = (type_Cmd >> 16);
                txMsg.data[2] = (type_Cmd-txMsg.data[1] >> 8);
                txMsg.data[3] = type_Cmd - (txMsg.data[2] << 8);
                send(txMsg);
                status = SHARE_BUS;
                can->filter(MY_ID, 0xFFF, CANStandard, 0);
        
                // Attach a function when message received
                can->attach(onCanReceived);
                t.start();
            }
        }
        
        
        
    
        while(status == SHARE_BUS) {
            if(t.read() > 1){
                pc.printf("I will try again\r\n");
                status = WAIT_FREE_BUS;
                delete can;
                can = new CAN(PA_11, PA_12, 1000000);
                init_can();
                can->filter(MY_ID, 0xFFF, CANStandard, 0);
                t.reset();
                t.start();
            }
            /*if(can->read(rxMsg) or can->read(rxMsg, 1)) {          // if message is available, read into msg
                printMsg(rxMsg);
                //pc.printf("Message received: %d\n", rxMsg.data);   // display message data
            }*/
            /*for (int i=0; i<100; i++){
                pc.printf("%d\r\n", i);
                wait_ms(210);
            }*/
            //wait_ms(100);
        }
    }
    
}

void init_can(){
    // Change/set frequency :
    //      can1.frequency(1000000);
    
    // Change/set mode : (CAN::Normal, CAN::Silent, CAN::LocalTest, CAN::GlobalTest, CAN::SilentTest)
    can->mode(CAN::Normal);
    
    // Set filter #0 to accept only standard messages with ID == RX_ID
    can->filter(MY_ID, 0xFFF, CANStandard, 0);
    
    // Attach a function when message received
    can->attach(onCanReceived);
}