#include <string>
#include <vector>

#include "mbed.h"
#include "ConsoleAPI.h"
#include "Device.h"

#include "Motor.h"
#include "Servo.h"
#include "3_wheels_Vehicule.h"

using namespace std;

Serial pc(D1, D0);
Serial bt(PB_6, PB_7);

Motor m1(PB_4 ,PC_10, PC_12, PA_0, PA_4, PC_3); // Create a L298HBridge object 
Motor m2(PB_5, PB_2, PB_12, PB_14, PC_7, PC_4); // Create a L298HBridge object
Motor m3(PC_8, PD_2, PC_11, PC_6, PA_15, PC_2); // Create a L298HBridge object

Servo servo1(PA_1); 
Servo servo2(PA_10);
Servo servo3(PA_9);



void led_switch(void);

/*Ticker time_up;
 
void led_switch() {
    //pc.printf("%f \t %f \t %f\n",m1.getOut(), m2.getOut(), m3.getOut()); //m1.getOut());
    //pc.printf("%f \t %f \t %f\n",m1.getCom(), m2.getCom(), m3.getCom());
}*/

int main() {
    
    pc.baud(115200);
    bt.baud(9600);
    //Add serial to API
    ConsoleAPI::add_serial(&pc);
    ConsoleAPI::add_serial(&bt);
    
    servo1.calibrate(0.001,90); //portée de -90 à 90
    servo2.calibrate(0.001,90);
    servo3.calibrate(0.001,90);
    
    servo1.write(0.5);
    servo2.write(0.48);
    servo3.write(0.5);
    
    Vehicule3 robot(&m1, &m2, &m3, &servo1, &servo2, &servo3, 0.125);
    
    while (1){
        ConsoleAPI::check_command_line_argument();
    }
}