 #include "Multi_16.h"
    
    Mux::Mux(PinName s0Pin, PinName s1Pin, PinName s2Pin, PinName s3Pin, PinName enPin):
    _s0(s0Pin), _s1(s1Pin), _s2(s2Pin), _s3(s3Pin), _en(enPin)
    {
    }
    
    void Mux::set_channel(int n)
    {        
        if (n < 16) {
            bool state[4];
            state[3] = 0b00001000 & n;  _s3 = state[3];
            state[2] = 0b00000100 & n;  _s2 = state[2];
            state[1] = 0b00000010 & n;  _s1 = state[1];
            state[0] = 0b00000001 & n;  _s0 = state[0];
            //printf("s0 = %d, s1 = %d, s2 = %d, s3 = %d\n", state[0], state[1], state[2], state[3]);
            open();
        }
        else{
            printf("Out of range.     Mux is closed \n");
            close();
        }
    }
    
    void Mux::open(){
        _en = false;
    }
    
    void Mux::close(){
        _en = true;
    }
