#include "mbed.h"
#include "DebouncedInterrupt.h"

DebouncedInterrupt mybutton(USER_BUTTON);
DigitalOut myled(LED1);
Serial sigfox(SERIAL_TX, SERIAL_RX);
 
float delay = 1.0; // 1 sec
bool etat = false;
bool buttontriggered = false;

void onUp()
{
    buttontriggered = true;
}

void buttonhandle()
{
    etat = !etat;
    if (etat == true) {
        myled = 1;
        sigfox.printf("AT$ss=FFFF\r\n"); // code pour recevoir "allume" sur le POC Radhius
        }
    else {
        myled = 0;
        sigfox.printf("AT$ss=0000\r\n"); // code pour recevoir "eteint" sur le POC Radhius
        }
}
 
int main()
{
    wait(2);
    // sigfox.printf("AT$ss=0000\r\n");
    mybutton.attach(&onUp, IRQ_FALL, 100);
    while (1) {
        if (buttontriggered == true) {
            buttontriggered = false;
            buttonhandle();
            }
    }
}