#include "mbed.h"

AnalogIn   F1p(PA_0);
AnalogIn   F1n(PA_1);
AnalogIn   F2p(PA_4);
AnalogIn   F2n(PB_0);
AnalogIn   F3p(PC_1);
AnalogIn   F3n(PC_0);
PwmOut     LED(PA_5);
PwmOut     M1(PA_6);
PwmOut     M2(PA_7);
PwmOut     M3(PB_6);

typedef float penposition;
typedef float angle;

class robot {
public:
    robot();                  // Initialization eg. PWM period, home position
    void SetPosition(void);   // Assign robot arm trajectory
    void ReadPosition(void);  // Read current pen's tip position

private:
    penposition X,Y,Z;        // position of pen's tip
    penposition xm,ym,zm;     // position from measurment
    angle A,B,C;              // angle of RC servo motors
    angle am,bm,cm;           // angle from measurment
    float e1,e2,e3;           // Error signal
    unsigned int d1,d2,d3;    // duty cycle 
    
    angle conv2A(penposition X, penposition Y, penposition Z); // Use Invert kinematic to solve A
    angle conv2B(penposition X, penposition Y, penposition Z); // Use Invert kinematic to solve B
    angle conv2C(penposition X, penposition Y, penposition Z); // Use Invert kinematic to solve C
     
    angle ReadamAngle(void);   // Read am from RC servo 1 
    angle ReadbmAngle(void);   // Read bm from RC servo 2
    angle ReadcmAngle(void);   // Read cm from RC servo 3
    
    angle subtractA(angle A, angle am); // A - am
    angle subtractB(angle B, angle bm); // B - bm
    angle subtractC(angle C, angle cm); // C - cm
  
    unsigned int PIDM1(float e1); // PID for RC servo 1
    unsigned int PIDM2(float e2); // PID for RC servo 2
    unsigned int PIDM3(float e3); // PID for RC servo 3
    
    void DriveM1(unsigned int d1); // Set duty cycle for RC servo 1
    void DriveM2(unsigned int d2); // Set duty cycle for RC servo 2
    void DriveM3(unsigned int d3); // Set duty cycle for RC servo 3
    
    penposition conv2xm(angle am, angle bm, angle c); //Use forward kinematic to solve xm
    penposition conv2ym(angle am, angle bm, angle c); //Use forward kinematic to solve ym
    penposition conv2zm(angle am, angle bm, angle c); //Use forward kinematic to solve zm
     
};
// Constructor
robot::robot(){
    // Set PWM period
    M1.period_ms(20);
    M2.period_ms(20);
    M3.period_ms(20);
    // move to home position 
    M1.pulsewidth_us(20000*0.05);
    M2.pulsewidth_us(20000*0.05);
    M3.pulsewidth_us(20000*0.05);
}

// Assign trajectory
void robot::SetPosition(void){
}

// Display pen's postion
void robot::ReadPosition(void){
    printf("Pen postion:\n");
    printf("x = %f\n",xm);
    printf("y = %f\n",ym);
    printf("z = %f\n",zm);
}

// Invert Kinematic
angle robot::conv2A(penposition X, penposition Y, penposition Z){
    return A;
}
angle robot::conv2B(penposition X, penposition Y, penposition Z){
    return B;
}
angle robot::conv2C(penposition X, penposition Y, penposition Z){
    return C;
}

// Measure angle
angle robot::ReadamAngle(void){
    am = F1p-F1n;
    return am;
}
angle robot::ReadbmAngle(void){
    bm = F2p-F2n;
    return bm;
}
angle robot::ReadcmAngle(void){
    cm = F3p-F3n;
    return cm;
}   

// Error signal
angle robot::subtractA(angle A, angle am){
    e1 = A - am;
    return e1;
}
angle robot::subtractB(angle B, angle bm){
    e2 = B - bm;
    return e2;
}
angle robot::subtractC(angle C, angle cm){
    e3 = C - cm;
    return e3;
}

// PID controllers
unsigned int robot::PIDM1(float e1){
    return d1;
}
unsigned int robot::PIDM2(float e2){
    return d2;
}
unsigned int robot::PIDM3(float e3){
    return d3;
}

// Assign pulsewidth
void robot::DriveM1(unsigned int d1){
    M1.pulsewidth_us(d1);
}
void robot::DriveM2(unsigned int d2){
    M2.pulsewidth_us(d2);
}
void robot::DriveM3(unsigned int d3){
    M3.pulsewidth_us(d3);
}
 // Forward Kinematic
penposition robot::conv2xm(angle am, angle bm, angle c){
    return xm;
}
penposition robot::conv2ym(angle am, angle bm, angle c){
    return ym;
}
penposition robot::conv2zm(angle am, angle bm, angle c){
    return zm;
}

int main() {
    
    float ans;
    robot R1;
    R1.ReadPosition();
    ans++;
    while(1);
}

