#include "mbed.h"

AnalogIn   F1p(PA_0); // Set PA_0 for ADC

PwmOut M1(PA_6);      // Set PA_6 as LED output
PwmOut LED(PA_5);     // Set PA_5 for driving RC servo

// class declation
class robotarm{
public:
       int readVR(void);      
       void setpwmperiod(int);
       void setpwmwidth(float);
};

// read voltage form VR
int robotarm::readVR (void) {
    return F1p;
}
// set period of PWM signal
void robotarm::setpwmperiod(int p_ms){
    M1.period_ms(p_ms);
}
// set pulse width of PWM signal
void robotarm::setpwmwidth(float width){
    M1.pulsewidth_us(width);
} 
     
int main() {
    
    robotarm group1; // Define object

    group1.setpwmperiod(20); // set period for PWM at pin PA_6 (defined in class)
    LED.period_ms(20);       // set period for PWM at pin PA_5 (general case)
    
    while(1) {
    group1.setpwmwidth(group1.readVR()*20000);  // set pulse width of PWM at pin PA_6 (defined in class)   
    LED.pulsewidth_us(F1p*20000);               // set pulse width of PWM at pin PA_5 (general case)
    }
}
