#include "mbed.h"
#include "pid.h"
#include "kinematic.h"

Kinematic  ANGLE;
PID        PosM1;
AnalogIn   F3p(PC_1);
AnalogIn   F3n(PC_0);

PwmOut     LED(PA_5);
PwmOut     M1(PA_6);
PwmOut     M2(PA_7);
PwmOut     M3(PB_6);

Serial UART(SERIAL_TX, SERIAL_RX);

class Armrobot{
    private:                                    
        float A,B,C;                                    //Angle of Servo
        float am,bm,cm;                                 //Angle from measurment
        
    public:
        void setHomePos(void);
        void SetPosition(void);  

};
void Armrobot::setHomePos(void){
    
    // Set PWM period
    M1.period_ms(20);
    M2.period_ms(20);
    M3.period_ms(20);
    
    // move to home position 
    M1.pulsewidth_us(20000*0.05);
    M2.pulsewidth_us(20000*0.05);
    M3.pulsewidth_us(20000*0.05);
}
float pos_x,pos_y,radius;
        
int main() {
    
    M1.period_ms(20);
    M2.period_ms(20);
    M3.period_ms(20);
    
    while(1) {

           M1.pulsewidth_us(1040);
           M2.pulsewidth_us(800);
           M3.pulsewidth_us(1900);
           
           printf("FB3 = %f V\r\r\n",F3p-F3n);
           wait(0.5f);

    }
}
