#include <math.h>
class Kinematic{
    private:
    
        double X,Y,Z;
        double base_hgt;
        double humerus;
        double ulna;
        double pen;
        

    public:

        void setBaseHight(double basehightsize){base_hgt = basehightsize;}
        void setHumerus(double humerussize){humerus = humerussize;}
        void setUlna(double ulnasize){ulna = ulnasize;}
        void setPen(double penoffset){pen = penoffset;}
        
        double solveA(double , double);                    // Use Inverse kinematic to solve A
        double solveB(double , double , double );           // Use Inverse kinematic to solve B
        double solveC(double , double , double );           // Use Inverse kinematic to solve C
};

double Kinematic::solveA(double X ,double Y){
        return atan2( X, Y );
}
double Kinematic::solveB(double X ,double Y ,double Z){
        double rdist = sqrt(( X * X ) + ( Y * Y ));
          
        /* rdist is y coordinate for the arm */
        Y = rdist;
          
        /* Wrist position */
        double wrist_z = Z - base_hgt;
        double wrist_y = Y - pen;
          
        /* Shoulder to wrist distance ( AKA sw ) */
        double s_w = ( wrist_z * wrist_z ) + ( wrist_y * wrist_y );
        double s_w_sqrt = sqrt( s_w );
    
        double a1 = atan2( wrist_z, wrist_y );
          
        /* s_w angle to humerus */
        double a2 = acos((((humerus*humerus) - (ulna*ulna) ) + s_w ) / ( 2 * humerus * s_w_sqrt ));
          
        /* shoulder angle */
        double shl_angle_r = a1 + a2;
        double shl_angle_d = ( shl_angle_r * 180 )/3.14159265;
        
        return shl_angle_d;
}
double Kinematic::solveC(double X ,double Y ,double Z){
        
        double rdist = sqrt(( X * X ) + ( Y * Y ));
          
        /* rdist is y coordinate for the arm */
        Y = rdist;
          
        /* Wrist position */
        double wrist_z = Z - base_hgt;
        double wrist_y = Y - pen;
          
        /* Shoulder to wrist distance ( AKA sw ) */
        double s_w = ( wrist_z * wrist_z ) + ( wrist_y * wrist_y );
        
        double elb_angle_r = acos(( (humerus*humerus) + (ulna*ulna) - s_w ) / ( 2 * humerus * ulna ));
        double elb_angle_d = ( elb_angle_r * 180)/3.14159265;
        double elb_angle_dn = ( 180.0 - elb_angle_d );
        
        return elb_angle_dn;
}