class PID{
    private:
        float error;
        float sample;
        float lastSample;
        float kP, kI, kD;      
        float P, I, D;
        float pid;
        float setPoint;
    
    public:
        
        void setGain(float , float , float);
        void setSample(float _sample){sample = _sample;}
        void setSetPoint(float _setPoint){setPoint = _setPoint;}
        float process();
};
void PID::setGain(float _kP, float _kI, float _kD){
            kP = _kP;
            kI = _kI;
            kD = _kD;
}
float PID::process(){
                
            error = setPoint - sample;
            
            P = error * kP;
            
            I = I + (error * kI);
            
            D = (lastSample - sample) * kD ;
            lastSample = sample;
            
            pid = P + I + D;
            
            return pid;
}
