#include "mbed.h"        // I/O, Math library etc.
#include "rtos.h"        // Real time OS library
#include "trajectory.h"  // Trajectory of circle
#include "robot.h"       // Kinematic of uArm
#include "pid.h"         // Close loop control function
#include "pwm.h"         // Set period and dutycycle for each servo motor
#include "a2d.h"         // A/D convert from voltage to angle  

unsigned int i = 100;                   // Data index
unsigned int j = 0;
unsigned int num = 37;
float v1,v2,v3,v1avg,v2avg,v3avg;
Serial UART(SERIAL_TX, SERIAL_RX);      // Define object "UART" as Serial type
MotorDriver Mset1;                      // Initial PWM period || arg(Link1,Link2,Link3,Link4)
Sensor Sen1;
 
void state_thread(void const *args);    // Thread for change inder every 1 second  
void read_thread(void const *args);     // Thread for change read every 1 second
void drive_thread(void const *args);     // Thread for change read every 1 second    

int main() {

    UART.baud(9600);               // Set BuadRate 9600 bps
    /*
    SetCircle circle1(50.0f,250.0f,0.0f,num);                            // Initial Circle trajectory || arg(radius,OriginX,OriginY,Number of data point)
    Kinematic uARM1(16.0f,81.0f,148.0f,155.0f,55.0f,45.0f);              // Initial Dimension of uARM robot || arg(T1X,T1Z,T2,T3,T4X,T4Z)
    for(j=0;j<num;j++)
    {
        uARM1.inverse(circle1.GetX(j),circle1.GetY(j),circle1.GetZ(j),j);
        printf("A[%d] = %f, B[%d] = %f, C[%d] = %f\r",j,uARM1.GetA(j),j,uARM1.GetB(j),j,uARM1.GetC(j)); // Test
    }
    j= 0;
    
    PIDcontroller PID1(0,0,0,0.04), PID2(0,0,0,0.04), PID3(0,0,0,0.04);  // Initial 3 PID controller for each motor
    */
    
    Thread thread_count(state_thread,NULL,osPriorityNormal,1024,NULL);
    //Thread thread_read(read_thread,NULL,osPriorityNormal,1024,NULL);
    Thread thread_drive(drive_thread,NULL,osPriorityNormal,1024,NULL);

    while(1) {
        //convert to angle (A B C)
        //uARM1.inverse(circle1.GetX(i),circle1.GetY(i),circle1.GetZ(i)); 
        // Mapping to duty cycle (D1 D2 D3) period 20,000 us applicable 0-180 -> 0 - 2,000
        //Mset1.Angle2Duty(uARM1.GetA(),uARM1.GetB(),uARM1.GetC());
        //printf("\rShow A = %f, B = %f, C = %f\r",uARM1.GetA(),uARM1.GetB(),uARM1.GetC()); // Test
        // Drive
        //printf("\rShow D1 = %d, D2 = %d, D3 = %d\r",Mset1.GetD1(),Mset1.GetD2(),Mset1.GetD3()); // Test
        
        /*
        Mset1.Angle2Duty(110,150,75);
        Mset1.Actuate();
        wait(2);
        Mset1.Angle2Duty(110,120,75);
        Mset1.Actuate();
        wait(2);
        Mset1.Angle2Duty(110,180,75);
        Mset1.Actuate();
        wait(2);
        */
        
        //Mset1.Angle2Duty(100,100,100);
        //Mset1.Actuate();
        //wait(2);
        
        //Mset1.DirectDrive(1025,1500,570);
        //wait(0.5f);
        
        //printf("\rShow X%d = %f, Y%d = %f, Z%d = %f\r",i,circle1.GetX(i),i,circle1.GetY(i),i,circle1.GetZ(i)); // Test
        //wait(0.5f);
    }
}

void state_thread(void const *args){
    while(1)
    {   
        if(i<num){
            i++;
        }
        else{ 
            i = 0;
        }
        
        printf("\rHi i=%d\r",i);
        Thread::wait(2000);         // wait for 2 seconds
    }
}

void read_thread(void const *args){

    while(1)
    {   
        if(j<50){
        v1 =  v1 + Sen1.GetV1();
        v2 =  v2 + Sen1.GetV2();
        v3 =  v3 + Sen1.GetV3();
        j++;
        }
        else{
            j = 0;
            v1avg = v1/50;
            v2avg = v2/50;
            v3avg = v3/50;
            //printf("v1avg = %f v2avg = %f v3avg = %f",v1avg,v2avg,v3avg);
            v1 = 0;
            v2 = 0;
            v3 = 0;
        }
        Thread::wait(40);         // wait for 40 ms
    }
}

void drive_thread(void const *args){
    while(1)
    {   
        Mset1.DriveTable(i);
        printf("\rHi duty=%d\r",i);
        printf("\rdu1[%d] = %d du2[%d] = %d du3[%d] = %d\r",i,Mset1.Getdu1(i),i,Mset1.Getdu2(i),i,Mset1.Getdu3(i));
        Thread::wait(1000);         // wait for 1 seconds
    }
}