#include <mbed.h>
#include <USBSerial.h>
#include "slcan.h"

static const uint16_t VID = 0x1209;
static const uint16_t PID = 0x0001;
static const uint16_t VERSION = 0x0001;


CAN can1(D9, D10);
USBSerial virtualUART(VID, PID, VERSION, false);
USBSLCAN slcan(virtualUART, can1);

//Serial hwUART(USBTX, USBRX);
//SerialSLCAN slcan(hwUART, can1);

Timer timer;
DigitalOut led(LED1);
DigitalOut led2(LED2);

int main() {
    virtualUART.connect(false);
    //hwUART.baud(115200);

    led = 0;
    led2 = 1;
    while(1) {
        bool active = false;
        //active = slcan.update();
        
        if (virtualUART.configured()) {
            led2 = 0;
            active = slcan.update();
        } else {
            led2 = 1;
            virtualUART.connect(false);
        }
        
        if (active) {
            timer.reset();
            timer.start();
        }
        
        if (timer.read_ms() > 100) {
            led = 0;
            timer.stop();
        } else {
            led = 1;
        }
    }
}