/*
Created on: 15/08/2018
Author: Rohan Gurav
        
Code: Use the following code to read the ADXL355 values connected to the SPI channel 
      of the EV-COG4050-Expander board port0. Check the readme.md for connection info  
      
*/
#include "mbed.h"
#include "ADXL355.h"
#include "complex.h"


Serial pc(USBTX, USBRX);
int axis = 0;

ADXL355 accl(SPI1_CS0, SPI1_MOSI, SPI1_MISO, SPI1_SCLK);    // PMOD port

float single_axis(float x);
float dual_axis(float x, float y);
float tri_axis(float x, float y, float z);
    
int main()
{
    pc.baud(9600);
    pc.printf("SPI ADXL355 and ADXL357 Demo\r\n");
    pc.printf("GET device ID\r\n");
   
    accl.reset();
    uint8_t d; 
    
    wait(0.2);
    
    d=accl.read_reg(accl.DEVID_AD);
    pc.printf("AD id = %x \r\n",d);
    
    d=accl.read_reg(accl.DEVID_MST);
    pc.printf("MEMS id = %x \r\n",d);
    
    d=accl.read_reg(accl.PARTID);
    pc.printf("device id = %x \r\n",d);
    
    d=accl.read_reg(accl.REVID);
    pc.printf("revision id = %x \r\n",d);
    
    pc.printf("GET device data [x, y, z, t] \r\n");
    accl.set_power_ctl_reg(accl.MEASUREMENT);
    
    d=accl.read_reg(accl.POWER_CTL);
    pc.printf("power control on measurement mode = %x \r\n",d);
    
    float x,y,z,t;
        
    double tilt_x, tilt_y,tilt_z;
    
    pc.printf("Enter no of axis for angle calculation (1/2/3):\r\n");
    pc.scanf("%d",&axis);
    
    pc.printf("||x_accl||y_accl||z_accl||Temp||x_tilt||y_tilt||z_tilt||");
    
    /*The following part is used to perform 2's complemient and then display the data*/
    while (1)
    {
        
        
        x = accl.convert(accl.scanx())*accl.axis355_sens;
        y = accl.convert(accl.scany())*accl.axis355_sens;
        z = accl.convert(accl.scanz())*accl.axis355_sens;
        t = 25+float(accl.scant()-1852)/(-9.05);
    
        if (axis==1)
        {
            tilt_x = single_axis(x);
            tilt_y = single_axis(y);
            tilt_z = single_axis(z);
        
            pc.printf("||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f|| \r\n" , x,y,z,tilt_x,tilt_y,tilt_z);
            wait(0.5);
        }
        
        if (axis==2)
        {
            tilt_x = dual_axis(x,z);
            tilt_y = dual_axis(y,z);
                    
            pc.printf("||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f|| \r\n" , x,y,z,tilt_x,tilt_y);
            wait(0.5);
        }
      
        if (axis==3)
        {
            tilt_x = tri_axis(x,y,z);
            tilt_y = tri_axis(y,x,z);
            
            tilt_z = atan((sqrt((x*x)+(y*y)))/z);
            tilt_z = floor(tilt_z*100)/100;
                    
            pc.printf("||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f|| \r\n" , x,y,z,tilt_x,tilt_y, tilt_z);
            wait(0.5);
        }
        
    }

}


//single axis
    float single_axis(float x)
    {
        double Y;
        //int a=4;
        Y = floor(asin(x)*100)/100;
        //void arm_cmplx_mag_f32  (double *Y, double *X, int32_t a);       

        Y = floor(((57.2957f)*(Y))*100)/100;
        return Y;
                    
    }

//Dual Axis
    float dual_axis(float x, float y)
    {
        double Y;
        Y = 57.2957f * (atan(x/y));
        Y = floor(Y*100)/100;
        return Y;    
    }

//Triaxial
    float tri_axis(float x, float y, float z)
    {
        double Y;
        double X;
        X = (x)/(sqrt((y*y)+(z*z)));
        Y= atan(X);
        Y = floor(Y*57.2957*100)/100;
        return Y;    
    }
