#include "mbed.h"

int thumb[8]  = {\
0b00100000,\
0b01010000,\
0b11111000,\
0b10001000,\
0b10001111,\
0b00001000,\
0b00001000,\
0b00000111};

int fft_val[8] = {2,5,7,3,4,6,2.8};//random

void bootup();
void led_line_char(int state);
void led_line_graph(int state);
void digitaIO(int pin, int val);

int main() {
    bootup();
    
    while(1){
        for(int i =0 ;i<8;i++){
            int y = 9+i;
            digitaIO(y,1); 
            //led_line_char(thumb[i]);
            led_line_graph(fft_val[i]);
            wait(1.0/8.0/144.0);
            digitaIO(y,0); 
        }
    }
}

void bootup(){
    for(int i =1 ;i<=8;i++){
        digitaIO(i,0);
    }
    for(int i =9 ;i<=16;i++){
        digitaIO(i,1);
    }
    wait(.2);
    for(int i =1 ;i<=8;i++){
        digitaIO(i,1);
    }
    wait(.2);
    for(int i =1 ;i<=16;i++){
        digitaIO(i,0);
    }
}

void led_line_char(int state){
  int a = state;
  int b = 1;
  for(int i = 0;i<8;i++){
    int x = i+1;//8-i;
    b = a%2;
    digitaIO(x,!b);
    a = a/2;
  }
}

void led_line_graph(int state){
  int a = state;
  for(int i = 0;i<8;i++){
    int x = i+1;//8-i;
    if(i <= a){digitaIO(x,1);}
    else{digitaIO(x,0);}
  }
}

void digitaIO(int pin, int val){
    switch (pin){
        case 1 : { DigitalOut(D0,val); break;}
        case 2 : { DigitalOut(D1,val); break;}
        case 3 : { DigitalOut(D2,val); break;}
        case 4 : { DigitalOut(D3,val); break;}
        case 5 : { DigitalOut(D4,val); break;}
        case 6 : { DigitalOut(D5,val); break;}
        case 7 : { DigitalOut(D6,val); break;}
        case 8 : { DigitalOut(D7,val); break;}
        case 9 : { DigitalOut(D8,val); break;}
        case 10 : { DigitalOut(D9,val); break;}
        case 11 : { DigitalOut(D10,val); break;}
        case 12 : { DigitalOut(A5,val); break;}
        case 13 : { DigitalOut(D12,val); break;}
        case 14 : { DigitalOut(D13,val); break;}
        case 15 : { DigitalOut(D14,val); break;}
        case 16 : { DigitalOut(D15,val); break;} 
        default : { break; }    
    }
}