/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#pragma once


#define NETWORK_TEST_CMD_LIST \
    ADD_HEADER("Network commands:"), \
    ADD_CMD("setup",            networkSetupWeb,             "start/stop/check web setup", \
                                                             "Usage: setup <start/stop/status> [<ssid> [<password>]]\n" \
                                                             "Examples:\n" \
                                                             "> setup start MySSID password\n" \
                                                             "> setup check\n" \
                                                             "> setup stop"), \
    ADD_CMD("join",             networkJoin,                 "Join a network", \
                                                             "Usage: join [<ssid> [<password>]]"), \
    ADD_CMD("leave",            networkLeave,                "Leave a network", \
                                                             "Usage: leave"), \
    ADD_CMD("netstat",          networkStats,                "Get network information", \
                                                             "Usage: netstat"), \
    ADD_CMD("scan",             networkScan,                 "Return list of available networks", \
                                                             "Usage: scan [<channel list>/<all> [<ssid>]]\n" \
                                                             "Examples:\n" \
                                                             "> scan 1,6,11\n" \
                                                             "> scan all \"My Network's Name\""), \
    ADD_CMD("ping",             networkPing,                 "Ping a network", \
                                                             "Usage: ping [<host/IP address>]\n" \
                                                             "Examples:\n" \
                                                             "> ping    // ping the gateway\n" \
                                                             "> ping www.ack.me"), \
    ADD_CMD("lookup",           networkLookup,               "Resolve domain name to IP address", \
                                                             "Usage: lookup <domain>\n" \
                                                             "Examples:\n" \
                                                             "> lookup www.ack.me")


WiconnectResult networkSetupWebCommand(int argc, char **argv);
WiconnectResult networkJoinCommand(int argc, char **argv);
WiconnectResult networkLeaveCommand(int argc, char **argv);
WiconnectResult networkStatsCommand(int argc, char **argv);
WiconnectResult networkScanCommand(int argc, char **argv);
WiconnectResult networkPingCommand(int argc, char **argv);
WiconnectResult networkLookupCommand(int argc, char **argv);
