/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"



/*************************************************************************************************/
WiconnectResult networkStatsCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();
    NetworkStatus status;
    NetworkSignalStrength signal;
    uint32_t ip, nm, gw;
    bool dhcpEnabled;

    if(WICONNECT_FAILED(result, wiconnect->getIpSettings(&ip, &nm, &gw)))
    {
        LOG_INFO("Failed to get IP Settings");
    }
    else if(WICONNECT_FAILED(result, wiconnect->getDhcpEnabled(&dhcpEnabled)))
    {
        LOG_INFO("Failed to get DHCP setting");
    }
    else if(WICONNECT_FAILED(result, wiconnect->getNetworkStatus(&status)))
    {
        LOG_INFO("Failed to get network status");
    }
    else if(WICONNECT_FAILED(result, wiconnect->getSignalStrength(&signal)))
    {
        LOG_INFO("Failed to get signal strength");
    }
    else
    {
        char ipStr[16], gwStr[16], nmStr[16];

        LOG_INFO("\r\n------------------------\r\n"
                 "IP: %s\r\n"
                 "Netmask: %s\r\n"
                 "Gateway: %s\r\n"
                 "DHCP enabled: %s\r\n"
                 "Status: %s\r\n"
                 "Signal: %s\r\n"
                 "------------------------",
                 Wiconnect::ipToStr(ip, ipStr),
                 Wiconnect::ipToStr(nm, nmStr),
                 Wiconnect::ipToStr(gw, gwStr),
                 dhcpEnabled ? "true" : "false",
                 Wiconnect::networkStatusToStr(status),
                 Wiconnect::signalStrengthToStr(signal));

    }

    return result;
}

/*************************************************************************************************/
WiconnectResult networkPingCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    uint32_t pingTimeMs;
    const char *domain = (argc > 0) ? argv[0] : NULL;

    if(!WICONNECT_FAILED(result, wiconnect->ping(domain, &pingTimeMs)))
    {
        LOG_INFO("Ping reply: %dms", pingTimeMs);
    }
    return result;
}

/*************************************************************************************************/
WiconnectResult networkLookupCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    if(argc != 1)
    {
        return WICONNECT_BAD_ARG;
    }

    uint32_t ipAddress;

    if(!WICONNECT_FAILED(result, wiconnect->lookup(argv[0], &ipAddress)))
    {
        IpStrBuffer buffer;
        LOG_INFO("IP Address: %s", Wiconnect::ipToStr(ipAddress, buffer));
    }
    return result;
}
