/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#pragma once


#define WICONNECT_TEST_CMD_LIST \
    ADD_HEADER("WiConnect commands:"), \
    ADD_CMD(":",            wiconnectSendRawBlocking,           "Send a blocking raw wiconnect command to module",      \
                                                                "Usage: : <wiconnet command> [command options]\n"       \
                                                                "Example:\n> : get network.status"),                    \
    ADD_CMD("#",            wiconnectSendRawNonBlocking,        "Send a non-blocking raw wiconnect command to module",  \
                                                                "Usage: # <wiconnet command> [command options]\n"       \
                                                                "Example:\n> # get network.status"),                    \
    ADD_CMD("ver",          wiconnectGetVersion,                "Get WiConnect version string",                         \
                                                                "Usage: ver"),                                          \
    ADD_CMD("update",       wiconnectUpdateFirmware,            "Update the Wi-Fi module's internal firmware",          \
                                                                "Usage: update [-f] [<version>]\n"                      \
                                                                "Examples:\n"                                           \
                                                                "> update          // update to latest firmware (if necessary)\n" \
                                                                "> update -f       // force update all files to latest verison\n" \
                                                                "> update 2.0.0.11 // update to specific version"),     \
    ADD_CMD("debug",        wiconnectDebugEnable,               "Enabled/disable wiconnect library debug messages",     \
                                                                "Usage: debug <on/off>")




WiconnectResult wiconnectSendRawBlockingCommand(int argc, char **argv);
WiconnectResult wiconnectSendRawNonBlockingCommand(int argc, char **argv);
WiconnectResult wiconnectGetVersionCommand(int argc, char **argv);
WiconnectResult wiconnectUpdateFirmwareCommand(int argc, char **argv);
WiconnectResult wiconnectDebugEnableCommand(int argc, char **argv);
