/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"


#define TEST_SERVER_URL "http://www.posttestserver.com"
#define CONTEXT_TYPE "text/plain"


static WiconnectResult addPostData(WiconnectSocket &socket);
static WiconnectResult readResponse(WiconnectSocket &socket);


/*************************************************************************************************/
WiconnectResult socketHttpPostCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();
    WiconnectSocket socket(0, NULL, TEST_BUFFER_LENGTH, TEST_BUFFER);
    uint32_t status;

    if(WICONNECT_FAILED(result, wiconnect->httpPost(socket, TEST_SERVER_URL, CONTEXT_TYPE)))
    {
        LOG_ERROR("Failed to open POST connection");
    }
    else if(WICONNECT_FAILED(result, addPostData(socket)))
    {
        LOG_ERROR("Failed to add POST data");
    }
    else if(WICONNECT_FAILED(result, wiconnect->httpGetStatus(socket, &status)))
    {
        LOG_ERROR("Failed to read HTTP status");
    }
    else if(WICONNECT_FAILED(result, readResponse(socket)))
    {
        LOG_ERROR("Failed to read POST response");
    }

    return result;
}

/*************************************************************************************************/
static WiconnectResult addPostData(WiconnectSocket &socket)
{
    WiconnectResult result;

    LOG_INFO("Enter post data ('\\n' issues request):");

    int c;

    for(;;)
    {
        c = consoleSerial.getc();
        consoleSerial.putc(c);
        if(c == '\r')
            continue;
        if(c == '\n')
            break;

        if(WICONNECT_FAILED(result, socket.putc(c)))
        {
            return result;
        }
    }

    return socket.flushTxBuffer();
}

/*************************************************************************************************/
static WiconnectResult readResponse(WiconnectSocket &socket)
{
    uint8_t *buffer;
    uint16_t size;

    LOG_INFO("Response data:");

    while(socket.read(&buffer, &size) == WICONNECT_SUCCESS)
    {
        logWrite(buffer, size);
    }

    return WICONNECT_SUCCESS;
}
