/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"



static WiconnectResult addHeadersPrompt(Wiconnect *wiconnect, WiconnectSocket &socket);
static WiconnectResult readResponse(WiconnectSocket &socket);



/*************************************************************************************************/
WiconnectResult socketHttpGetCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();
    WiconnectSocket socket(TEST_BUFFER_LENGTH, TEST_BUFFER);
    const char *url;
    bool addHeaders = false;
    int savedTimeout = wiconnect->getCommandDefaultTimeout();

    if(argc < 1)
    {
        LOG_ERROR("must specify url");
        return WICONNECT_BAD_ARG;
    }
    url = argv[0];

    if(argc > 1)
    {
        addHeaders = true;
    }

    wiconnect->setCommandDefaultTimeout(15000);
    if(!WICONNECT_FAILED(result, wiconnect->httpGet(socket, url, addHeaders)))
    {
        uint32_t status;
        if(addHeaders)
        {
            if(WICONNECT_FAILED(result, addHeadersPrompt(wiconnect, socket)))
            {
                goto exit;
            }
            else if(WICONNECT_FAILED(result, wiconnect->httpGetStatus(socket, &status)))
            {
                goto exit;
            }
            LOG_INFO("HTTP Status: %d", status);
        }

        result = readResponse(socket);
    }

exit:
    wiconnect->setCommandDefaultTimeout(savedTimeout);

    return result;
}




/*************************************************************************************************/
static WiconnectResult addHeadersPrompt(Wiconnect *wiconnect, WiconnectSocket &socket)
{
    WiconnectResult result;

    char buffer[128];
    for(;;)
    {
        LOG_INFO("Enter header 'key,value\\n' (or 'done\\n' to issue request):");
        char *ptr = buffer;

        for(;;)
        {
            int c = consoleSerial.getc();
            consoleSerial.putc(c);
            if(c == '\r')
                continue;
            if(c == '\n')
            {
                *ptr = 0;
                break;
            }
            *ptr++ = (char)c;
        }

        if(strcmp(buffer, "done") == 0)
        {
            return WICONNECT_SUCCESS;
        }

        char *value = strchr(buffer, ',');
        if(value == NULL)
        {
            LOG_ERROR("Mal-formed key,value pair. Must be: <key>,<value>");
            continue;
        }

        *value++ = 0;

        if(WICONNECT_FAILED(result, wiconnect->httpAddHeader(socket, buffer, value)))
        {
            LOG_ERROR("Failed to add header key, value");
            break;
        }
    }

    return result;
}

/*************************************************************************************************/
static WiconnectResult readResponse(WiconnectSocket &socket)
{
    uint8_t c;

    LOG_INFO("Response data:");
    while(socket.getc(&c) == WICONNECT_SUCCESS) // NOTE: getc() is extremely inefficient here,
                                                //       is only used to test its functionality
    {
        logWrite(&c, 1);
    }

    return WICONNECT_SUCCESS;
}
