/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"



static void joinCompleteCallback(WiconnectResult result, void *arg1, void *arg2);


/*************************************************************************************************/
WiconnectResult networkJoinCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    const char *ssid = (argc > 0) ? argv[0] : NULL;
    const char *password = (argc > 1) ? argv[1] : NULL;

    // if we're changing the ssid, then we need to leave the current network we're connected to first
    if(ssid != NULL && WICONNECT_FAILED(result, wiconnect->leave()))
    {
        LOG_WICONNECT_ERROR(result, "Failed to disconnect from the network first");
    }
    else if(!WICONNECT_FAILED(result, wiconnect->join(ssid, password, Callback(joinCompleteCallback))))
    {
        LOG_INFO("Joining network");
    }

    return result;
}

/*************************************************************************************************/
WiconnectResult networkLeaveCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    if(!WICONNECT_FAILED(result, wiconnect->leave()))
    {
        LOG_INFO("Successfully disconnected from network");
    }
    return result;
}

/*************************************************************************************************/
static void joinCompleteCallback(WiconnectResult result, void *arg1, void *arg2)
{
    if(result == WICONNECT_SUCCESS)
    {
        LOG_INFO("Successfully joined network");
    }
    else
    {
        NetworkJoinResult joinResult = (NetworkJoinResult)(uint32_t)arg1;
        LOG_WICONNECT_ERROR(result, "Errors occurred while joining network. Join result: %s", Wiconnect::networkJoinResultToStr(joinResult));
    }
}
