/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdarg.h>


#include "Wiconnect.h"
#include "log.h"
#include "util/CommandProcessor/CommandProcessor.h"


extern ConsoleSerial consoleSerial;


/*************************************************************************************************/
void logDebug(const char *msg, ...)
{
    va_list args;

    consoleSerial.write("[DEBUG] ");
    va_start(args, msg);
    consoleSerial.vprintf(msg, args);
    va_end(args);
}

/*************************************************************************************************/
void logInfo(const char *msg, ...)
{
    va_list args;
    consoleSerial.write("[INFO] ");
    va_start(args, msg);
    consoleSerial.vprintf(msg, args);
    va_end(args);
}

/*************************************************************************************************/
void logWrite(const void *data, int size)
{
    consoleSerial.write(data, size);
}

/*************************************************************************************************/
void logInfoWriteStr(const char *msg, const char *s)
{
    consoleSerial.printf("[INFO] %s", msg);
    consoleSerial.write(s);
    consoleSerial.write("\r\n");
}

/*************************************************************************************************/
void logError(const char *msg, ...)
{
    va_list args;
    consoleSerial.write("[ERROR] ");
    va_start(args, msg);
    consoleSerial.vprintf(msg, args);
    va_end(args);
}

/*************************************************************************************************/
void logWiconnectError(WiconnectResult result, const char *msg, ...)
{
    va_list args;

    consoleSerial.printf("[ERROR] (%d) %s. ", result, Wiconnect::getWiconnectResultStr(result));
    va_start(args, msg);
    consoleSerial.vprintf(msg, args);
    va_end(args);
    consoleSerial.write("\r\n");
}

