/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"


#define TIMEOUT 10000 // ms


static volatile bool wiconnectNonBlockingCommandFinished = false;



/*************************************************************************************************/
WiconnectResult wiconnectSendRawBlockingCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    strcpy(testBuffer, argv[0]);
    --argc;
    ++argv;

    while(argc--)
    {
        strcat(testBuffer, " ");
        strcat(testBuffer, argv[0]);
        ++argv;
    }

    if(!WICONNECT_FAILED(result,  wiconnect->sendCommand(TIMEOUT, testBuffer, TEST_BUFFER_LENGTH, testBuffer)))
    {
        LOG_INFO_WRITE_STR("Response:\r\n", wiconnect->getResponseBuffer());
    }

    return result;
}



/*************************************************************************************************/
static void responseHandler(WiconnectResult result, void *response, void *responseLen)
{
    Wiconnect *wiconnect = Wiconnect::getInstance();

    wiconnectNonBlockingCommandFinished = true;

    if(result == WICONNECT_SUCCESS)
    {
        LOG_INFO_WRITE_STR("Non-blocking Response:\r\n", (const char*)response);
    }
    else
    {
        LOG_WICONNECT_ERROR(result, "Non-blocking command failed");
    }
}

/*************************************************************************************************/
WiconnectResult wiconnectSendRawNonBlockingCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    strcpy(testBuffer, argv[0]);
    --argc;
    ++argv;

    while(argc--)
    {
        strcat(testBuffer, " ");
        strcat(testBuffer, argv[0]);
        ++argv;
    }

    wiconnectNonBlockingCommandFinished = false;
    if(WICONNECT_FAILED(result,  wiconnect->sendCommand(Callback(responseHandler), testBuffer, TEST_BUFFER_LENGTH, TIMEOUT, testBuffer)))
    {
    }
    else if(!wiconnectNonBlockingCommandFinished)
    {
        LOG_INFO("Non-blocking command processing...");
    }

    return result;
}

/*************************************************************************************************/
WiconnectResult wiconnectGetVersionCommand(int argc, char **argv)
{
    WiconnectResult result;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    if(!WICONNECT_FAILED(result, wiconnect->getVersion(testBuffer, sizeof(testBuffer))))
    {
        LOG_INFO("Version: %s", testBuffer);
    }
    return result;
}

/*************************************************************************************************/
WiconnectResult wiconnectUpdateFirmwareCommand(int argc, char **argv)
{
    WiconnectResult result;
    bool forceUpdate = false;
    const char *version = NULL;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    if(argc > 0)
    {
        if(strcmp(argv[0], "-f") == 0)
        {
            forceUpdate = true;
        }
        else
        {
            version = argv[0];
        }
    }

    if(!WICONNECT_FAILED(result, wiconnect->updateFirmware(forceUpdate, version)))
    {
        wiconnect->getVersion();
        LOG_INFO("Success!");
        LOG_INFO("Firmware version: %s", wiconnect->getResponseBuffer());
    }

    return result;
}


/*************************************************************************************************/
WiconnectResult wiconnectDebugEnableCommand(int argc, char **argv)
{
    extern int wiconnectLogDebug(const char *str);
    Wiconnect *wiconnect = Wiconnect::getInstance();
    bool enabled;

    if(!StringUtil::parseBool(argv[0], &enabled))
    {
        return WICONNECT_BAD_ARG;
    }

    if(enabled)
    {
        wiconnect->setDebugLogger(LogFunc(wiconnectLogDebug));
        LOG_INFO("WiConnet debugging enabled");
    }
    else
    {
        wiconnect->setDebugLogger(LogFunc());
        LOG_INFO("WiConnet debugging disabled");
    }

    return WICONNECT_SUCCESS;
}
