/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#pragma once


#define SOCKET_TEST_CMD_LIST \
    ADD_HEADER("Socket commands:"), \
    ADD_CMD("get",               socketHttpGet,           "Issue HTTP GET request with optional headers", \
                                                          "Usage: get <url> [true]\n" \
                                                          "Examples:\n" \
                                                          "> get ack.me // immediately issue GET and print page\n" \
                                                          "> get ack.me true // issue GET then add HTTP headers\n"), \
    ADD_CMD("post",              socketHttpPost,          "Issue HTTP POST request to http://www.posttestserver.com/", \
                                                          "Usage: post\n" \
                                                          "Examples:\n" \
                                                          "> post // opens POST connection then enter the post data"), \
    ADD_CMD("tcp",               socketTcpClientEcho,     "Open TCP connection, transmit data and receivd echoed data", \
                                                          "Usage: tcp <host> <port> [<packets count> [<delay> <size>]]]"), \
    ADD_CMD("udp",               socketUdpClientEcho,     "Open UDP connection, transmit data and receivd echoed data", \
                                                          "Usage: udp <host> <port> [<packets count> [<delay> <size>]]]")



WiconnectResult socketTcpClientEchoCommand(int argc, char **argv);
WiconnectResult socketUdpClientEchoCommand(int argc, char **argv);
WiconnectResult socketHttpGetCommand(int argc, char **argv);
WiconnectResult socketHttpPostCommand(int argc, char **argv);
WiconnectResult socketHttpHeadCommand(int argc, char **argv);
