/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "tests/Tests.h"
#include "Wiconnect.h"


static void webSetupCompleteCallback(WiconnectResult result, void *arg1, void *arg2);


/*************************************************************************************************/
WiconnectResult networkSetupWebCommand(int argc, char **argv)
{
    WiconnectResult result = WICONNECT_BAD_ARG;
    Wiconnect *wiconnect = Wiconnect::getInstance();

    if(strcmp(argv[0], "status") == 0)
    {
        bool isRunning;

        if(!WICONNECT_FAILED(result, wiconnect->isWebSetupRunning(&isRunning)))
        {
            LOG_INFO("Web setup is %s", isRunning ? "running" : "stopped");
        }
    }
    else if(strcmp(argv[0], "start") == 0)
    {
        const char *ssid = (argc > 1) ? argv[1] : NULL;
        const char *password = (argc > 2) ? argv[2] : NULL;

        if(!WICONNECT_FAILED(result, wiconnect->startWebSetup(ssid, password, Callback(webSetupCompleteCallback))))
        {
            LOG_INFO("Web setup started");
        }
    }
    else if(strcmp(argv[0], "stop") == 0)
    {
        if(!WICONNECT_FAILED(result, wiconnect->stopWebSetup()))
        {
            LOG_INFO("Web setup stopped");
        }
    }

    return result;
}

/*************************************************************************************************/
static void webSetupCompleteCallback(WiconnectResult result, void *arg1, void *arg2)
{
    if(result == WICONNECT_SUCCESS)
    {
        LOG_INFO("Web setup successfully completed");
    }
    else
    {
        LOG_WICONNECT_ERROR(result, "Web setup finished with errors");
    }
}
