/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#pragma once

#define FILE_TEST_CMD_LIST \
    ADD_HEADER("File commands:"), \
    ADD_CMD("ls",            fileList,                       "list files (optionally by name, type, version)", \
                                                             "Usage: ls [-n <name>] [-t <type>] [-v <version>]\n" \
                                                             "Examples:\n" \
                                                             "> ls                  // list all files\n" \
                                                             "> ls -n *.exe         // list all executable files\n" \
                                                             "> ls -v 1.2           // list all files with version 1.2\n" \
                                                             "> ls -t FE            // list all miscellaneous files"), \
    ADD_CMD("create",       fileCreate,                      "create a file", \
                                                             "Usage: create <name> <size> [<version> [<type>]]\n" \
                                                             "Example:\n" \
                                                             "> create my_file.txt 100 4.56 // create file name 'my_file.txt'\n" \
                                                             "                              // immediately following should be 100 bytes of data"), \
    ADD_CMD("read",         fileRead,                        "read a file", \
                                                             "Usage: read <name>\n" \
                                                             "Example:\n" \
                                                             "> read my_file.txt "), \
    ADD_CMD("delete",       fileDelete,                      "delete a file", \
                                                             "Usage: delete <name>\n" \
                                                             "Example:\n" \
                                                             "> delete my_file.txt ")


WiconnectResult fileListCommand(int argc, char **argv);
WiconnectResult fileCreateCommand(int argc, char **argv);
WiconnectResult fileReadCommand(int argc, char **argv);
WiconnectResult fileDeleteCommand(int argc, char **argv);
