/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */
#pragma once


// The BAUD rate your PC/MAC/Linux terminal uses with the eval board
#define CONSOLE_BAUD 115200


// Uncomment this to enable WiConnect serial interface hardware flow control
// NOTE: your platform must support the serial flow control api functions
//#define ENABLE_FLOW_CONTROL


#define WICONNECT_INTERNAL_BUFFER_SIZE (4*1024)
#define WICONNECT_SERIAL_RX_BUFFER_SIZE (4*1024)

#define DEFAULT_CMD_GETCHAR_TIMEOUT 250
#define DEFAULT_COMMAND_LINE_LENGTH_MAX 128
#define DEFAULT_COMMAND_MAX_HISTORY 16
#define DEFAULT_CMD_PROMPT_STR "> "
#define DEFAULT_COMMAND_MAX_ARGV 16

#define TEST_NONBLOCKING_API false
#define TEST_BUFFER_LENGTH 4*1024


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Seabass Target Configuration
#ifdef TARGET_SEABASS

#define WICONNECT_TX_PIN PA_9
#define WICONNECT_RX_PIN PA_10
#define WICONNECT_RESET_PIN PB_0
#define WICONNECT_WAKE_PIN NC

#ifdef ENABLE_FLOW_CONTROL
#define WICONNECT_CTS_PIN PA_11
#define WICONNECT_RTS_PIN PA_12
#else
#define WICONNECT_CTS_PIN NC
#define WICONNECT_RTS_PIN NC
#endif

#endif


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Nucleo F401RE Target Configuration
#ifdef TARGET_NUCLEO_F401RE

#define WICONNECT_TX_PIN PA_9
#define WICONNECT_RX_PIN PA_10
#define WICONNECT_RESET_PIN PC_7
#define WICONNECT_WAKE_PIN NC

#ifdef ENABLE_FLOW_CONTROL
#define WICONNECT_CTS_PIN PA_11
#define WICONNECT_RTS_PIN PA_12
#else
#define WICONNECT_CTS_PIN NC
#define WICONNECT_RTS_PIN NC
#endif

#endif


