
#include "Wiconnect.h"
#include "target_config.h"

#define NETWORK_SSID "<YOUR NETWORK SSID HERE>"
#define NETWORK_PASSWORD "<YOUR NETWORK PASSWORD HERE>"

#define ECHO_SERVER_ADDRESS  "<ECHO Server's IP Addres HERE>"
#define ECHO_SERVER_PORT 7



static Serial consoleSerial(STDIO_UART_TX, STDIO_UART_RX);

static char in_buffer[256];

int main()
{
    WiconnectResult result;
    SerialConfig serialConfig(WICONNECT_RX_PIN, WICONNECT_TX_PIN, 256);
    Wiconnect wiconnect(serialConfig, 256, NULL, WICONNECT_RESET_PIN);

    consoleSerial.baud(115200);
    printf("Initializing WiConnect...\r\n");

    if(WICONNECT_FAILED(result, wiconnect.init(true)))
    {
        printf("Failed to initialize Wiconnect: %s\r\n", Wiconnect::getWiconnectResultStr(result));
        if(result == WICONNECT_FIRMWARE_OUTDATED)
        {
            printf("** The WiFi firmware is not supported. Run the ota example to update the firmware:\r\n");
            printf("https://developer.mbed.org/teams/ACKme/code/wiconnect-ota_example\r\n\r\n");
        }
        for(;;);
    }
    else if(WICONNECT_FAILED(result, wiconnect.join(NETWORK_SSID, NETWORK_PASSWORD)))
    {
        printf("Failed to join network: %s\r\n", Wiconnect::getWiconnectResultStr(result));
        for(;;);
    }


    UDPSocket  sock;
    sock.init();

    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);


    char out_buffer[] = "Hello World\n";
    if(sock.sendTo(echo_server, out_buffer, sizeof(out_buffer)) == -1)
    {
        printf("Failed to send data\r\n");
        for(;;);
    }


    int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));
    if(n == -1)
    {
        printf("Failed to receive data\r\n");
        for(;;);
    }
    in_buffer[n] = '\0';
    printf("%s", in_buffer);


    sock.close();
    wiconnect.deinit();

    printf("Finished!");
    while(true) {}
}
