/**
 * ACKme WiConnect Host Library is licensed under the BSD licence:
 *
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

#include "Wiconnect.h"
#include "api/types/Socket/UDPSocket.h"



/*************************************************************************************************/
UDPSocket::UDPSocket(int rxBufferLen, void *rxBuffer, int txBufferLen, void *txBuffer)
: Socket(rxBufferLen, rxBuffer, txBufferLen, txBuffer), localPort(SOCKET_ANY_PORT)
{
}

/*************************************************************************************************/
int UDPSocket::init(void)
{
    return 0;
}

/*************************************************************************************************/
// Server initialization
int UDPSocket::bind(int port)
{
    localPort = port;
    return 0;
}

/*************************************************************************************************/
int UDPSocket::join_multicast_group(const char* address)
{
    return -1;
}

/*************************************************************************************************/
int UDPSocket::set_broadcasting(bool broadcast)
{
    return 0;
}

/*************************************************************************************************/
// -1 if unsuccessful, else number of bytes written
int UDPSocket::sendTo(Endpoint &remote, char *packet, int length)
{
    if(!socket.isConnected())
    {
        if(Wiconnect::getInstance()->udpConnect(socket, remote.get_address(), remote.get_port(), localPort) != WICONNECT_SUCCESS)
        {
            return -1;
        }
    }
    return (socket.write(packet, length, true) == WICONNECT_SUCCESS) ? length : -1;
}

/*************************************************************************************************/
// -1 if unsuccessful, else number of bytes received
int UDPSocket::receiveFrom(Endpoint &remote, char *buffer, int length)
{
    uint16_t bytesRead;

    if(!socket.isConnected())
    {
        if(Wiconnect::getInstance()->udpConnect(socket, remote._ipAddress, remote.get_port(), localPort) != WICONNECT_SUCCESS)
        {
            return -1;
        }
    }

    if (!_blocking)
    {
        if(socket.getRxBufferSize() == 0 || socket.getRxBufferBytesPending() == 0)
        {
            TimeoutTimer timer;

            for(;;)
            {
                bool hasData;

                if(socket.poll(&hasData) != WICONNECT_SUCCESS)
                {
                    return -1;
                }
                else if(hasData)
                {
                    break;
                }
                else if(timer.timedOut(_timeout))
                {
                    return -1;
                }
            }
        }
    }

    if(length == 1 && socket.getRxBufferSize() > 0)
    {
        return (socket.getc((uint8_t*)buffer) == WICONNECT_SUCCESS) ? 1 : -1;
    }
    else
    {
        for(;;)
        {
            if(socket.read(buffer, length, &bytesRead) != WICONNECT_SUCCESS)
            {
                return -1;
            }
            else if(bytesRead > 0)
            {
                return bytesRead;
            }
        }
    }

}
