
#include <stdint.h>


#define LWIP_SOCKET 1
#define LWIP_TCP 1
#define LWIP_UDPLITE 1
#define LWIP_DNS 1

#define LWIP_DNS_API_DECLARE_H_ERRNO 0
#define LWIP_DNS_API_DEFINE_ERRORS 0

#define LWIP_PLATFORM_BYTESWAP 1


typedef uint8_t u8_t;
typedef uint16_t u16_t;
typedef uint32_t u32_t;

typedef int8_t s8_t;
typedef int16_t s16_t;
typedef int32_t s32_t;




#define PACK_STRUCT_FIELD(x) x __attribute__((packed))
  #define PACK_STRUCT_STRUCT __attribute__((packed))
  #define PACK_STRUCT_BEGIN
  #define PACK_STRUCT_END



#define LWIP_PLATFORM_HTONS(x) ( (((u16_t)(x))>>8) | (((x)&0xFF)<<8) )
#define LWIP_PLATFORM_HTONL(x) ( (((u32_t)(x))>>24) | (((x)&0xFF0000)>>8) \
                               | (((x)&0xFF00)<<8) | (((x)&0xFF)<<24) )


#ifdef LWIP_PLATFORM_BYTESWAP

#define htons LWIP_PLATFORM_HTONS
#define htonl LWIP_PLATFORM_HTONL
#define ntohs LWIP_PLATFORM_HTONS
#define ntohl LWIP_PLATFORM_HTONL

#else

#define htons(x) x
#define htonl(x) x
#define ntohs(x) x
#define ntohl(x) x

#endif
