/**
 * ACKme WiConnect Host Library is licensed under the BSD licence:
 *
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

#include "Wiconnect.h"
#include "api/types/Socket/Socket.h"





/*************************************************************************************************/
Socket::Socket() : _blocking(true), _timeout(1500)
{
}

/*************************************************************************************************/
Socket::Socket(int rxBufferLen, void *rxBuffer, int txBufferLen, void *txBuffer) :
        _blocking(true), _timeout(1500), socket(rxBufferLen, rxBuffer, txBufferLen, txBuffer)
{

}

/*************************************************************************************************/
Socket::~Socket()
{
    close(true);
}

/*************************************************************************************************/
void Socket::set_blocking(bool blocking, unsigned int timeout)
{
    _blocking = blocking;
     _timeout = timeout;
}

/*************************************************************************************************/
int Socket::set_option(int level, int optname, const void *optval, socklen_t optlen)
{
    return -1;
}

/*************************************************************************************************/
int Socket::get_option(int level, int optname, void *optval, socklen_t *optlen)
{
    return -1;
}

/*************************************************************************************************/
int Socket::close(bool shutdown)
{
    return (socket.close() == WICONNECT_SUCCESS) ? 0 : -1;
}


