/*
 * Copyright 2014, ACKme Networks
 * All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of ACKme Networks;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of ACKme Networks.
 */


#include "Wiconnect.h"
#include "api/types/Socket/Socket.h"



/*************************************************************************************************/
int gethostbyname_r(const char *name, struct hostent *ret, char *buf, size_t buflen, struct hostent **result, int *h_errnop)
{
    return -1;
}

/*************************************************************************************************/
struct hostent *gethostbyname(const char *name)
{
    static uint8_t buffer[sizeof(struct hostent) + sizeof(void*)*3 + 1*sizeof(uint32_t)];
    struct hostent *hostPtr = (struct hostent*)buffer;
    char **ipPtrList = (char**)&buffer[sizeof(struct hostent)];
    char **aliasPtrList = (char**)&buffer[sizeof(struct hostent) + sizeof(void*)*2];
    uint32_t *ipPtr = (uint32_t*)&buffer[sizeof(struct hostent) + sizeof(void*)*3];


    hostPtr->h_addr_list = ipPtrList;
    hostPtr->h_aliases = aliasPtrList;
    hostPtr->h_addrtype = AF_INET;
    hostPtr->h_length = sizeof(uint32_t);
    hostPtr->h_name = (char*)name;

    aliasPtrList[0] = NULL;
    ipPtrList[0] = (char*)ipPtr;
    ipPtrList[1] = NULL;

    Wiconnect *wiconnect = Wiconnect::getInstance();
    if(wiconnect->lookup(name, ipPtr) != WICONNECT_SUCCESS)
    {
        ipPtrList[0] = NULL;
    }

    return hostPtr;
}

/*************************************************************************************************/
u32_t ipaddr_addr(const char *cp)
{
    u32_t ip = 0;

    Wiconnect::strToIp(cp, &ip);

    return ip;
}

/*************************************************************************************************/
int ipaddr_aton(const char *cp, ip_addr_t *addr)
{
    return Wiconnect::strToIp(cp, &addr->addr) ? 0 : -1;
}

/*************************************************************************************************/
// returns ptr to static buffer; not reentrant!
char *ipaddr_ntoa(const ip_addr_t *addr)
{
    return (char*)Wiconnect::ipToStr(addr->addr);
}

/*************************************************************************************************/
char *ipaddr_ntoa_r(const ip_addr_t *addr, char *buf, int buflen)
{
    return (char*)Wiconnect::ipToStr(addr->addr, buf);
}
