/**
 * ACKme WiConnect Host Library is licensed under the BSD licence: 
 * 
 * Copyright (c)2014 ACKme Networks.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met: 
 * 
 * 1. Redistributions of source code must retain the above copyright notice, 
 * this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products 
 * derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 */

#include "Wiconnect.h"
#include "us_ticker_api.h"

/*************************************************************************************************/
TimeoutTimer::TimeoutTimer()
{
    _start = 0;
    us_ticker_init();
}

/*************************************************************************************************/
void TimeoutTimer::reset(void)
{
    _start = us_ticker_read();
}

/*************************************************************************************************/
TimerTimeout TimeoutTimer::remainingMs(TimerTimeout timeoutMs)
{
    volatile TimerTimeout diff = readMs();
    return (timeoutMs > diff) ? (timeoutMs - diff) : 0;
}

/*************************************************************************************************/
TimerTimeout TimeoutTimer::readMs()
{
    volatile TimerTimeout now = us_ticker_read();
    TimerTimeout remaining = (now > _start) ? (now - _start) : ((ULONG_MAX - _start) + now);
    return remaining / 1000;
}

/*************************************************************************************************/
bool TimeoutTimer::timedOut(TimerTimeout timeoutMs)
{
    volatile TimerTimeout now = us_ticker_read();
    return ((now - _start) / 1000) > timeoutMs;
}
