/**
 * @example ACKme_HelloWorld/main.cpp
 *
 * This example program verifies the operation of key features of the Nucleo board,
 * without the ACKme shield installed. 
 * It blinks the Nucleo board user LED, 
 * It increases the blink rate when you press the User button. 
 * It prints to a serial terminal connected to the USB port
 * and echoes characters entered at the terminal.
 * It responds, with a message, to typing 'hi <Enter>' at the terminal. 
 *
 */

#include "mbed.h"
// include C library headers
#include <stdio.h> // printf
#include <ctype.h> // tolower
#define ASCII_ESC 27
 
InterruptIn myButton(USER_BUTTON);
static Serial consoleSerial(STDIO_UART_TX, STDIO_UART_RX);
PwmOut myLed(LED1);

double defaultPeriod = 1.0f; // 1 second period
double defaultPulseWidth = defaultPeriod/2.0; // 1/2 second pulse (on)

double quickPeriod = 0.1f; // 
double quickPulseWidth = quickPeriod/2.0;
 
void pressed()
{
    myLed.period(quickPeriod);  
    myLed.pulsewidth(quickPulseWidth); 
}
void released()
{
    myLed.period(defaultPeriod);  
    myLed.pulsewidth(defaultPulseWidth); 
}

int main() {
    // specify period first, then everything else
    char c;
    char c0 = ' ';
    char c1 = ' ';
    char c2 = ' ';
    
    released();
    myButton.fall(&pressed);
    myButton.rise(&released);    
    
    consoleSerial.baud(115200); // console terminal to 115200 baud
    
    printf( "%c[2J", ASCII_ESC );   // clear screen     
    printf("\r\nHello World!\r\n...from ACKme Networks\r\n\r\n");    
    
    printf("This app verifies some features of your Nucleo board.\r\n");    
    printf("Verify that the user LED (LD2 on the Nucleo F401RE) is blinking.\r\n");
    printf("When you hold down the user button, the user LED blinks faster.\r\n");    
    printf("Characters you type on the terminal console are echoed.\r\n\r\n");
    printf("Type 'hi <Enter>' for a greeting.\r\n");    

    while(1) {
        if (consoleSerial.readable()){
            c = consoleSerial.getc(); //Read data from serial console
            consoleSerial.printf("%c",c);
            c0 = c1;
            c1 = c2;
            c2 = tolower(c);
            if ((c0 == 'h') && (c1 == 'i') && ((c2 == '\n') || (c2 == '\r'))){
                printf("\r\n\r\nHello!");
                printf("\r\nYou have successfully programmed your Nucleo board.");
                printf("\r\nNow turn off power to the board, and install");
                printf("\r\nthe ACKme AMW006-A02 (Mantis) Wi-Fi shield.");
            } 
        }
    }
}
