#ifndef CAL_H
#define CAL_H


typedef struct {
    float uv_zero_mV;  // uv adc mV reading at 0 ppb
    float uv_cal_mV;   // uv adc mV reading at calibration point
    float uv_cal_ppb;  // uv user ppb value at calibration point

    float vis_zero_mV;
    float vis_cal_mV;
    float vis_cal_ppb;

    uint16_t trim_4mA;     // 12-bit dac value to use for 4 mA
    uint16_t trim_20mA;    // 12-bit dac value to use for 20 mA
    float    ppb_at_20mA;  // ppb value equal to 20 mA, zero is assumed at 4
    
    uint16_t padding;  // needed to create multiple of 2 bytes
    //double mAOffsetValue; //mA Offset Value for simulator project. 
    uint16_t checksum;

} CALIBRATION_DATA; // compiler makes this a multiple of 2 bytes (half-word)

extern CALIBRATION_DATA g_cal;

void cal_init();
void cal_save();
void cal_print();
void cal_factory();
void cal_test();

#endif