#include "mbed.h"
#include "QEI.h"
#include "CAN.h"
#include "YukeySD.h"
Serial pc(USBTX, USBRX, 115200);
Serial md(PC_10, PC_11, 38400);
Serial md2(PD_5, PD_6, 38400);

CAN          can(PB_8, PB_9);
CANMessage   rxMsg;
CANMessage   txMsg;

PwmOut motor1(PF_8);
PwmOut motor2(PF_7);

YukeySD sd(can, 5);
// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
#define ROTATE_PER_REVOLUTIONS 1024    //For QEI's pulse data
#define ROTATE_PER_REVOLUTIONS2 48
int r;
int s;
double a;
double b=0.05;
double c;
double p = 7.6;
double rpm = 0.35;
double now=0;
double theta;
double target_a=260;
double target_b=160;
double target_c=60;
double target_d=10;
double target_m=0;
double kp=0.2;
double move1;
double move2;
double move3;
double move4;
double move0;
double rote;
int kai=0;
uint8_t sd_data=0x00;
DigitalIn btn(USER_BUTTON);
DigitalOut led(LED2);
DigitalIn sw1(D0);
DigitalIn sw2(D1);
DigitalIn sw3(D2);

void moter(int x){
    r = x + 128;
    md.putc(r);
    pc.printf("%d\r\n", r);
}

void moter2(int y){
    s = y + 128;
    md2.putc(s);
    pc.printf("%d\r\n", s);
}

void throw1(void){
    QEI wheel2(PD_4, PD_3, NC, ROTATE_PER_REVOLUTIONS2, QEI::X4_ENCODING);
    
    while(kai==1){
        moter2(64);
        c = (double)wheel2.getPulses();
        if(sw3==0){
            moter2(0);
            kai = 2;
        }
    }
    wait(1.0);
    
    while(c!=0){
        moter2(-64);
        c = (double)wheel2.getPulses();
    }
    
    sd_data+=0x01;
    sd.out(sd_data);
    wait_ms(500);
    sd_data-=0x01;
    sd.out(sd_data);
}

void reset(void){
    int i = 0;
    
    while(i == 0){
        moter(-128);
        if(sw1==0 or sw2==0){
            i = 1;
            break;
        }
    }
    moter(64);
    wait(1.0);
    moter(0);
}

int main()
{
    md.format(8,Serial::None,1);
    md2.format(8,Serial::None,1);
    moter(0);
    reset();
    
    while(!btn){
        led=!led;
        wait(0.05);
    }
    
    can.reset();

    led = 1;

    can.frequency(1000000);
    
    while(btn){}
        // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    QEI wheel(PC_8, PC_9, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
    while(1){
        a = (double)wheel.getPulses();
        theta = a * rpm;
        now = theta * p / 360;
        move1=target_a - now;
        move2=target_b - now;
        move3=target_c - now;
        move4=target_d - now;
        //rote=(int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS);
        pc.printf("kai:%d\r\n", kai);
        pc.printf("theta:%f\r\n", theta);
        pc.printf("now:%f\r\n", now);
        pc.printf("location:%f\r\n", move1);
        //pc.printf("location:%d\r\n", move2);
        pc.printf("Pulses:%07f\r\n", (double)wheel.getPulses());
        //pc.printf("Rotate:%d\r\n", rote);
        if(sw1==1&&sw2==1){
            pc.printf("oitrotateencoder\r\n");
            if((int)move1>0&&kai==0){
                moter(127);
                pc.printf("a\r\n");
                if((int)move1<5){
                    moter(54);
                    if((int)move1==1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                        throw1();
                        reset();
                    }
                }
            }
            if((int)move1<0&&kai==0){
                moter(-128);
                pc.printf("b\r\n");
                if((int)move1>-5){
                    moter(-54);
                    if((int)move1==-1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                        throw1();
                        reset();
                    }
                }
            }
            /*if((int)move2>0&&kai==0){
                moter(127);
                pc.printf("a\r\n");
                if((int)move2<5){
                    moter(54);
                    if((int)move2==1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            if((int)move2<0&&kai==0){
                moter(-128);
                pc.printf("b\r\n");
                if((int)move2>-5){
                    moter(-54);
                    if((int)move2==-1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            if((int)move3>0&&kai==0){
                moter(127);
                pc.printf("a\r\n");
                if((int)move3<5){
                    moter(54);
                    if((int)move3==1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            if((int)move3<0&&kai==0){
                moter(-128);
                pc.printf("b\r\n");
                if((int)move3>-5){
                    moter(-54);
                    if((int)move3==-1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            if((int)move4>0&&kai==0){
                moter(127);
                pc.printf("a\r\n");
                if((int)move4<5){
                    moter(54);
                    if((int)move4==1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            
            if((int)move4<0&&kai==0){
                moter(-128);
                pc.printf("b\r\n");
                if((int)move4>-5){
                    moter(-54);
                    if((int)move4==-1){
                        wait(0.25);
                        moter(0);
                        kai=1;
                    }
                }
            }
            if((int)move0>0&&kai==0){
                reset();
            }
            
            if((int)move0<0&&kai==0){
                reset();
            }*/
        } else {
            moter(0);
        }
    //    moter(0);
    }
}
