#ifndef PS3_CONTROLLER_H
#define PS3_CONTROLLER_H

#include "mbed.h"
#include "string.h"//文字列いじる用

#define PS          0  //0b01
#define TRIANGLE    1
#define CIRCLE      2
#define CROSS       3
#define SQUARE      4
#define UP          5
#define RIGHT       6
#define DOWN        7
#define LEFT        8
#define L1          9
#define L3          10
#define R1          11
#define R3          12
#define SELECT      13
#define START       14

#define PS_LX 0
#define PS_LY 1
#define PS_RX 2
#define PS_RY 3
#define PS_L2 4
#define PS_R2 5

#define bitRead(value, bit) (((value) >> (bit)) & 0x01)//arduinoのbitread関数

class PS3_controller
{
public:
    PS3_controller(PinName TX, PinName RX);
    PS3_controller(Serial &uno);
    void send_UNO(int);
    void read_PAD(void);
    int button(int);
    int analog(int);
    bool conect(void);
    void disconect(void);

private:
    Serial _uno;
    int send_data;
    uint8_t str[9];
    unsigned long all_button_on_off;
    uint8_t botton;
    uint8_t  sthick_value[6];
    bool controller_check;

protected:

};

#endif