#include "PS3_Controller.h"

PS3_controller::PS3_controller(PinName TX, PinName RX) : _uno(TX,RX)
{
    _uno.baud(57600);
}
PS3_controller::PS3_controller(Serial &uno):_uno(uno)
{
    _uno.baud(57600);
}

void PS3_controller::read_PAD()
{
    _uno.putc(send_data);

    while(!_uno.readable()) {}

    for(int i=0; i<9; i++) str[i]=_uno.getc();

    all_button_on_off = (str[1] << 8);
    all_button_on_off = (all_button_on_off & 0xff00);
    all_button_on_off = (all_button_on_off | str[0]);

    for(int i=0; i<6; i++) sthick_value[i] = str[i+2];

    controller_check = str[8];
}

void PS3_controller::send_UNO(int send_pattern)
{
    send_data = send_pattern;
}

int PS3_controller::button(int button_pattern)
{
    return bitRead(all_button_on_off,button_pattern);
}

int PS3_controller::analog(int sthick_pattern)
{
    return sthick_value[sthick_pattern];
}

bool PS3_controller::conect(void)
{
    return controller_check;
}

void PS3_controller::disconect(void){
    _uno.putc(3);
}