// BULME Graz,     
// by F. Wolf   01.11.2019
/*
                             PIN-OUT-NUClight
                                NUCLEO-L432KC
                     RGB-rot   D1|-------| VIn
                     RGB-gruen D0|       | GND
                             NRST|       | RST
                              GND|       | 5V0
                        LED1 <-D2|       | A7
                        LED2 <-D3|       | A6 -> LED7
SDA (I2C)  (MPU6050 gyro)   <- D4|       | A5
SCL (I2C)  (MPU6050 gyro)   <- D5|       | A4
                        LED3 <-D6|       | A3 -> POTI
                            nc D7|       | A2 -> Taster
                            nc D8|       | A1 -> Taster
                         LED4  D9|       | A0 -> DS18B20
                  RGB-blau <- D10|       | ARF
                      LED5 <- D11|       | 3V0
                      LED6 <- D12|-------| D13 -> LED8
 */   
#include "mbed.h"
#include "DS1820.h"  // library Zoltan Hudak 

#define STR_MAX 10
DigitalOut led1(LED1);
DigitalOut led2(D3);
DigitalOut led3(D6);
DigitalOut led4(D9);

Serial pc(USBTX, USBRX);    
DS1820 ds1820(A0);

char str[STR_MAX];
char str2[STR_MAX];
int index=0;

int main()
{
    float fwert = 12.23;
    float twert = 22.5;
    char key1[] = "1";
    char key2[] = "2";
    char key3[] = "3";
    char key4[] = "D";
    char keyR[] = "RD";
    char keyW[] = "FWR";
    char keyX[] = "IXX";
    char keyZ[] = "TA";

    if (ds1820.begin()) {
      ds1820.startConversion();
      twert = ds1820.read();
    } else {
        twert = 22.5;
    }
    while (1) {
        led1 = !led1;
        pc.scanf("%s", str);
        if(!strcmp(str, key1)) {
            //led1=!led1;
        } else if(!strcmp(str, key2)) {
            led2=!led2;
        } else if(!strcmp(str, key3)) {
            led3=!led3;
        } else if(!strcmp(str, key4)) {
            led4=!led4;
        } else if(!strcmp(str, keyR)) {
            //led4=1;
            snprintf(str2, STR_MAX, "%f", fwert);
            pc.printf("%s\n\r", str2);
        } else if(!strcmp(str, keyX)) {
            //led4=0;
            pc.printf("%d\n", 7);
        } else if(!strcmp(str, keyW)) {
            //led4=0;
            pc.printf("%f\n", fwert);
        } else if(!strcmp(str, keyZ)) {
            //led4=0;
            pc.printf("%f\n", twert); 
        }
    }
}