
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,PB_6);  // MOSI, SCLK, CS
Serial pc(D1,D0);

/**** Main Function  ***/
int main(void)
{
    MCP.frequency(7000000);

    uint16_t i=0;
    uint8_t state=0;
    uint8_t chk=0;
    uint8_t data;
    while(1) {
        if(state==0) {
            i++;
            MCP.writeA(i);
            if(i==0x7FF){
                state=1;
            }
        }
        
        else if (state==0 && chk==1){
            ++i;
            MCP.writeA(i);
            if(i==0x7FF){
                state=1;
            }
        }
        
        if(state==1){
            --i;
            MCP.writeA(i);
            if(i==0){
                state=2;
            }   
        }
                
        if(state==2){
            i = 0x0FFE;
            MCP.writeA(i);
            state = 3;
        }
        
        if(state==3){
            if(i > 0x7FF){
                --i;
                MCP.writeA(i);
                if(i == 0x7FF){
                    state = 4;
                }
            }
        }
        
        if(state==4){
            ++i;
            MCP.writeA(i);
            if(i == 0x0FFE){
                i = 0;
                MCP.writeA(i);
                state = 5;
            }
        }
        
        if(state==5){
            chk = 1;
            state = 0;
        }
        
        if(pc.readable()){
            data = pc.getc();
            if(data=='s'){
                pc.printf("i: %d, state: %d \n", i, state);
            }
        }
        wait_us(11.99);
    }
}

/*
if(i < 0x0FFE) {
            i++;

        } else {
            i=0;
            state = ~state;
        }

        if(state ==0) {
            MCP.writeA(i);
        } else {
            MCP.writeA( ((~i)+1)&0x0FFF);
        }
*/