#include "mbed.h"
//#include "motor.h"

 
PwmOut wheelf1(PC_8);//前部
PwmOut wheelf2(PC_6);
PwmOut wheelr1(PA_11);//右部
PwmOut wheelr2(PB_1);
PwmOut wheell1(PB_7);//左部
PwmOut wheell2(PC_9);

SPISlave device(PB_15,PB_14,PB_13,PB_12);
//SPISlave ps3(PB_5,PB_4,PB_3,PA_4);

Serial pc(USBTX,USBRX);

DigitalIn button(USER_BUTTON);

InterruptIn a(PA_8);//前部
InterruptIn b(PA_9);
InterruptIn c(PB_6);//右部
InterruptIn d(PC_7);
InterruptIn e(PC_0);//左部
InterruptIn f(PC_1);

Ticker timer;
Ticker jiko;
                            
int count_f=0,count_r=0,count_l=0;
int pa,pb,pC,pd,pe,pf;
int i;
int dateA,dateB,dateC;
int ka,kb,kc;                 
int df,dr,dl;
         
float angle_f=0.0,angle_r=0.0,angle_l=0.0;
float angle_old_f=0.0,angle_old_r=0.0,angle_old_l=0.0;
float duty_out_f=0.0,duty_out_r=0.0,duty_out_l=0.0;
float duty_PID_f=0.0,duty_PID_r=0.0,duty_PID_l=0.0;
float omega_now_f=0.0,omega_now_r=0.0,omega_now_l=0.0;
float rot_now_f=0.0,rot_now_r=0.0,rot_now_l=0.0;
float rot_old_f=0.0,rot_old_r=0.0,rot_old_l=0.0;
float rot_PID_f=0.0,rot_PID_r=0.0,rot_PID_l=0.0;
float rot_prop_f=0.0,rot_prop_r=0.0,rot_prop_l=0.0;
float rot_diff_f=0.0,rot_diff_r=0.0,rot_diff_l=0.0;
float rot_inte_f=0.0,rot_inte_r=0.0,rot_inte_l=0.0;

const float Kp=10.0000,Kd=20.0000,Ki=0.0001;
const float resolution=1024.0;

//interrupt
void risea()
{ pa=1;
  if(pb==0) {count_f++;}
  else {count_f--;}
  }
void falla()
{ pa=0;
  if(pb==0) {count_f--;}
  else {count_f++;}
  }
void riseb()
{ pb=1;
  if(pa==0) {count_f--;}
  else {count_f++;}
  }
void fallb()
{ pb=0;
  if(pa==0) {count_f++;}
  else {count_f--;}
  }
  
  
void risec()
{ pC=1;
  if(pd==0) {count_r++;}
  else {count_r--;}
  }
void fallc()
{ pC=0;
  if(pd==0) {count_r--;}
  else {count_r++;}
  }
void rised()
{ pd=1;
  if(pC==0) {count_r--;}
  else {count_r++;}
  }
void falld()
{ pd=0;
  if(pC==0) {count_r++;}
  else {count_r--;}
  }
  

void risee()
{ pe=1;
  if(pf==0) {count_l++;}
  else {count_l--;}
  }
void falle()
{ pe=0;
  if(pf==0) {count_l--;}
  else {count_l++;}
  }
void risef()
{ pf=1;
  if(pe==0) {count_l--;}
  else {count_l++;}
  }
void fallf()
{ pf=0;
  if(pe==0) {count_l++;}
  else {count_l--;}
  }

void flip_f()
{
    angle_f=count_f/resolution*2.0*3.14;
    omega_now_f=abs(angle_f-angle_old_f)/0.01;
    rot_now_f=omega_now_f*10/(2.0*3.14);
    angle_old_f=angle_f;
    rot_old_f=rot_now_f;
}

void flip_r()
{
    angle_r=count_r/resolution*2.0*3.14;
    omega_now_r=abs(angle_r-angle_old_r)/0.01;
    rot_now_r=omega_now_r*10/(2.0*3.14);
    angle_old_r=angle_r;
    rot_old_r=rot_now_r;
}

void flip_l()
{
    angle_l=count_l/resolution*2.0*3.14;
    omega_now_l=abs(angle_l-angle_old_l)/0.01;
    rot_now_l=omega_now_l*10/(2.0*3.14);
    angle_old_l=angle_l;
    rot_old_l=rot_now_l;
}

void motor_f(int dir_f,float rot_target_f)
{
    rot_prop_f=rot_target_f-rot_now_f;
    rot_diff_f=rot_now_f-rot_old_f;
    rot_inte_f+=rot_prop_f;
    rot_PID_f=Kp*rot_prop_f+Kd*rot_diff_f;//+Ki*rot_inte;
    duty_PID_f=rot_PID_f*1.092*0.0001;
    duty_out_f=duty_out_f+duty_PID_f;

    if(duty_out_f>0.5) {
        duty_out_f=0.5;
    } else if(duty_out_f<0) {
        duty_out_f=0;
    }

    if(dir_f==1) {
        wheelf1=duty_out_f;
        wheelf2=0;
    } else if(dir_f==-1) {
        wheelf1=0;
        wheelf2=duty_out_f;
    } else {
        wheelf1=0;
        wheelf2=0;
    }
}


void motor_r(int dir_r,float rot_target_r)
{
    rot_prop_r=rot_target_r-rot_now_r;
    rot_diff_r=rot_now_r-rot_old_r;
    rot_inte_r+=rot_prop_r;
    rot_PID_r=Kp*rot_prop_r+Kd*rot_diff_r;//+Ki*rot_inte;
    duty_PID_r=rot_PID_r*1.092*0.0001;
    duty_out_r=duty_out_r+duty_PID_r;

    if(duty_out_r>0.5) {
        duty_out_r=0.5;
    } else if(duty_out_r<0) {
        duty_out_r=0;
    }

    if(dir_r==1) {
        wheelr1=duty_out_r;
        wheelr2=0;
    } else if(dir_r==-1) {
        wheelr1=0;
        wheelr2=duty_out_r;
    } else {
        wheelr1=0;
        wheelr2=0;
    }
}

void motor_l(int dir_l,float rot_target_l)
{
    rot_prop_l=rot_target_l-rot_now_l;
    rot_diff_l=rot_now_l-rot_old_l;
    rot_inte_l+=rot_prop_l;
    rot_PID_l=Kp*rot_prop_l+Kd*rot_diff_l;//+Ki*rot_inte;
    duty_PID_l=rot_PID_l*1.092*0.0001;
    duty_out_l=duty_out_l+duty_PID_l;

    if(duty_out_l>0.5) {
        duty_out_l=0.5;
    } else if(duty_out_l<0) {
        duty_out_l=0;
    }

    if(dir_l==1) {
        wheell1=duty_out_l;
        wheell2=0;
    } else if(dir_l==-1) {
        wheell1=0;
        wheell2=duty_out_l;
    } else {
        wheell1=0;
        wheell2=0;
    }
}

void motor(){
        
    if(device.receive()){
            device.format(16,3);
            device.frequency(100000);
            
            for(i=0;i<3;i++){
                if(i==0){
                    dateA=device.read();
                    }
                else if(i==1){
                    dateB=device.read();
                    }
                else{
                    dateC=device.read();
                    }               
             }   
    }
}




int main(){
     
     printf("start");
    while(1){
    if(button==1){
        wheelf1=0;
        wheelf2=0;
        wheelr1=0;
        wheelr2=0;
        wheell1=0;
        wheell2=0;
        }
     else{
    wheelf1.period_us(50);
    wheelf2.period_us(50);
    wheelr1.period_us(50);
    wheelr2.period_us(50);
    wheell1.period_us(50);
    wheell2.period_us(50);
   
    //pc.printf("start program.\n\r");
    timer.attach(&flip_f,0.01);
    timer.attach(&flip_r,0.01);
    timer.attach(&flip_l,0.01);
    
    //interrupt
    a.rise(&risea);                     
    a.fall(&falla);                    
    b.rise(&riseb);                     
    b.fall(&fallb);
    c.rise(&risec);                     
    c.fall(&fallc);                    
    d.rise(&rised);                     
    d.fall(&falld);
    e.rise(&risee);                     
    e.fall(&falle);                    
    f.rise(&risef);                     
    f.fall(&fallf);
   
    duty_out_f=0.0;
    duty_out_r=0.0;
    duty_out_l=0.0;
    count_f=0;
    count_r=0;
    count_l=0;
    angle_f=0.0;
    angle_r=0.0;
    angle_l=0.0;
    
    
            
    while(1) {
                
            jiko.attach(&motor,0.01);   
    
   // pc.printf("%d/%d/%d\n\r",dateA,dateB,dateC);
    
     dateA-=8192;
         if(dateA>=4096){
             df=-1; //マイナスにカウント方向
             ka=dateA-4096;
             }
         else if(dateA<0){
             df=0; //動かさない
             ka=0;
             }
         else{
             df=1; //プラスにカウント方向
             ka=dateA;
             }
         
         dateB-=16384;
         if(dateB>=4096){
             dr=-1;
             kb=dateB-4096;
             }
         else if(dateB<0){
             dr=0;
             kb=0;
             }    
         else{
             dr=1;
             kb=dateB;
             }
        
        
        dateC-=24576;
        if(dateC>=4096){
            dl=-1;
            kc=dateC-4096;
            }
        else if(dateC<0){
            dl=0;
            kc=0;
            }
        else{
            dl=1;
            kc=dateC;
            }
            
            
        motor_f(df,ka);//回転方向、目標回転数を指定
        motor_r(dr,kb);
        motor_l(dl,kc);
        wait(0.1);
        
        pc.printf("%d,%f//%d,%f//%d,%f\n\r",count_f,duty_out_f,count_r,duty_out_r,count_l,duty_out_l);
       }  
    }
    }
    }