#include "mbed.h"
#include "pin_file.h"
#include <string.h>
#ifndef SPI_NUCLEO_H
#define SPI_NUCLEO_H
//SPI mbed
SPISlave from_mbed(PA_7, PA_6, PA_5, PA_4);
//SPI NUCLEO
SPISlave from_gyro(PB_15, PB_14, PB_13, PB_12);
//SPI mbed
bool RR=0,LR=0,Xpm=0,cilinder=0,onoff=0,updown=0,Ypm=0;
int speed_X,speed_Y;
//SPI NUCLEO
void spi_mbed();
void spi_nucleo();
void getGyro();
void spiInit();
typedef unsigned u16;
u16 FM;
long int angle;
double now_angle;
Serial pc(USBTX,USBRX);
void spiInit();
void spi_mbed();
void getGyro();
#endif

void spiInit()
{
    from_mbed.format(16,3);
    from_gyro.format(16,3);
    from_mbed.frequency(1000000);
    from_gyro.frequency(1000000);
}

void spi_mbed()
{       
    if(from_mbed.receive()) {
        RR=0;
        LR=0;
        FM=from_mbed.read();
        Xpm=FM>>13;
        Ypm=(FM&0x10)>>4;
        cilinder=(FM&0x0100)>>8;
        onoff=(FM&0x0080)>>7;
        updown=(FM&0x0040)>>6;
        if((FM>>15)==1) {
            RR=1;
        } //右旋回の関数へ
        else if((FM>>14)==1) {
            LR=1;
        } //左旋回の関数へ
        else if(Xpm==1) { //コントローラーのＸ方向成分入力
            speed_X=FM&0x1e00;
            speed_X=speed_X>>9;
            if(Ypm==0) speed_Y=FM&0xf;
            else {
                speed_Y=FM&0xf;
                speed_Y=(-1)*speed_Y;
            }
        }
        else {
            speed_X=FM&0x1e00;
            speed_X=speed_X>>9;
            speed_X=(-1)*speed_X;
            if(Ypm==0) speed_Y=FM&0xf;
            else {
                speed_Y=FM&0xf;
                speed_Y=(-1)*speed_Y;
            }
        }
    }
}

void getGyro()
{
    int data;
    if(from_gyro.receive()) {
        data = from_gyro.read();
    if(data >> 15) angle = -(data & 0x7fff);
        else angle = data & 0x7fff;
        now_angle = (double)angle / 10;
//        pc.printf("%d\r\n",data);
    }
}
