// bole&bloss検出関数の定義
// bole:測距     bloss:タッチ


typedef struct{
    int r;
    int l;
}survey;

survey IR_check();

int check(int n,bool c);

long rater(long x, long in_min, long in_max, long out_min, long out_max) {
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/*
void state_check() {      //タッチセンサ確認

         sw1_n=sw1;
         sw2_n=sw2;
    
    if(sw1_n*sw1_p*sw2_n*sw2_p) {
        sw_state=1;
    }else{
        sw_state=0;
        }
    
    sw1_p=sw1_n;  
    sw2_p=sw2_n;  
}



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


*/
void bole_check() {       //測距センサ確認
    double res;

    uw.output();
    uw=0;
    wait_us(10);
    uw=1;
    wait_us(3);
    uw=0;

    uw.input();
    meas_pulse.start();
    while(!uw) {
        meas_pulse.reset();
        meas_pulse.start();
    }
    do {
        res=meas_pulse.read_us();
    } while(uw);
    meas_pulse.stop();

    dist=(res/2)*340/1000;      //[us]*[mm/us]=[mm]

    pc.printf("%8.3f\t",dist);

    if(UWMIN<dist<UWMAX) {
        UW=1;
    } else {
        UW=0;
    }

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    survey val;
    
    val=IR_check();

//    pc.printf("%d\t%d\n\r", r, l);


    if(val.r<LIMITR&&val.l<LIMITL) {
        IR=1;
    } else {
        IR=0;
    }

}


survey IR_check(){
        survey c;
        
        c.r=check(100,1);
        c.l=check(100,0);
        
        //analog値(0~65535)->mV(0~3300)
        c.r=rater(c.r,0,65535,0,3300);
        c.l=rater(c.l,0,65535,0,3300);
        //mV(600~2200)->mm(500~40)
        c.r=rater(c.r,600,2200,500,40);
        c.l=rater(c.l,600,2200,500,40);
        
        pc.printf("IR:r=%d l=%d\n\r",c.r,c.l);
        pc.printf("\n\r");
        
        return c;

}

int check(int n,bool s){
    long a=0;
    
    if(s){
        for(int i=0;i<n;i++){
            a=a+IR_r.read_u16();
            }
    }else{
        for(int i=0;i<n;i++){
            a=a+IR_l.read_u16();
            }
    }
    
    return a/n;
}
