#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#include "mbed.h"
int a=0;
int RSX,RSY,LSX,LSY,BSU,BSL,H=0,h=0;
bool circleState=0;
//これより下に関数外に書く要素を記入する
PwmOut led1(LED1);
PwmOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
SPI m(p5, p6, p7);
DigitalOut cs(p8);
void UserLoopSetting()
{
    //一度だけ行いたい初期設定をここに書く
    led1.period_ms(20);
}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //データ取得例
    int M=0,move=0,updown=0;
    
    m.format(16,3);
    m.frequency(1000000);
    cs=0;

    //以下の整数ＭをＳＰＩで送る
    //整数Ｍを16桁の二進数とする。
    //桁数|  16  |  15  |    14   |13|12|11|10|     9    |    8   |    7    | 6 |    5    |4|3|2|1|
    //指示|右旋回 |左旋回 |Ｘの＋or－|  出力0~15  |アームonoff|上下onoff|  上下+- |空白|Ｙの＋orー|出力0~15|
    if((ButtonState >> BUTTONR1)&1) {
        M=1<<15;
    } else if((ButtonState >> BUTTONL1)&1) {
        M=1<<14;
    } else {
        if(LSX-129>0) {
            M=1;
            M=M<<4;
            M+=(LSX-128)/8;
            M=M<<9;
        } else if(LSX-127<0) {
            if(((LSX-128)/8)==-16) M+=15;
            else M+=(-1)*((LSX-128)/8);
            M=M<<9;
        }
        if((ButtonState >> BUTTONTRIANGEL)&1) {
            //○が押されたとき
            circleState=1;
            a=0;
        } else {
            //a=0;
            if(circleState == 1) {
                if(H == 0) {
                    H = 1;
                } else {
                    H = 0;
                }
                circleState = 0;
            }else circleState = 0;
            //a++;
        }
        h=H<<8;
    if((ButtonState >> BUTTONUP)&1) {
        move=1<<7;
        updown=1<<6;
    } else if((ButtonState >> BUTTONDOWN)&1) {
        move=1<<7;
    }
    if(LSY-129>0) {
        M+=0x10;
        M+=(LSY-128)/8;
    } else if(LSY-127<0) {
        if(((LSY-128)/8)==-16) M+=15;
        else M+=(-1)*((LSY-128)/8);
    } else {
        M=0;
    }
    }
    M+=h;
    M+=move;
    M+=updown;
    
//    m.write(0xffff);
    m.write(M);
//  printf("%d,%d\n\r",M&0x40,0x40);

    led1=LSX/256.0f;
    led2=LSY/256.0f;
    led3=ButtonState & 0x0400;  //L1の状態
    led4=ButtonState & 0x0800;  //R1の状態
//値の取得はps3.hを参照
    cs=1;
    printf("M:%d\t,h:%d\t,updown:%d\t,move:%d\t,a=%d\t\n",M,H,updown,move,a);
}
