#ifndef _INCLUDED_SERIALSERVO_H_
#define _INCLUDED_SERIALSERVO_H_

SerialHalfDuplex master(p9,p10);
#define ID 0

void initSerialServo(){
    master.baud(115200);
    master.format(8,Serial::Even,1);
    printf("Initialize Complete !!\r\nID = %d\r\n\n",ID);
}

void set_degree(char id, float degree)
{
//void set_degree(int id, float degree){
//    printf("set_degree\n");
    char pos_h,pos_l;
    long pos = 8000 * degree / 270 + 3500; // (11500-3500)÷270 = 29.62 ≒30
    pos_h = pos / 128;              //上位7bit
    pos_l = pos % 128;              //下位7bit
    // set position
    master.putc(0x80+id);// ID
//    printf("send id\n");

    master.putc(pos_h);             //position(3500-11500 | 0-270deg)
//    printf("send pos_h\n");

    master.putc(pos_l);
//    printf("send pos_l\n");
/*
    int ret1 = master.getc() - 128;
    int ret2 = master.getc();
    int ret3 = master.getc();
    printf("ret : id=%d, H=%x, L=%x, deg=%d\n", ret1, ret2, ret3, ((ret2*128+ret3)-3500)*270/8000);
*/
}
// <setID readID>
// setID、readID使用時はサーボと1対1で接続すること
void setID(char id)
{
//    printf("setID\n");
    master.putc(0xE0+id);
    master.putc(0x01);
    master.putc(0x01);
    master.putc(0x01);
}
void readID(void)
{
//    printf("readID\n");
    master.putc(0xFF);
//    printf("0xFF\n");
    master.putc(0x00);
//    printf("0x00 1\n");
    master.putc(0x00);
//    printf("0x00 2\n");
    master.putc(0x00);
//    printf("0x00 3\n");
    char id = master.getc() - 224;
    printf("ret : %d\n", id);
}

#endif