#ifndef _S9706_H_
#define _S9706_H_

#include "OriginalPinMap.h"

//S9706
DigitalIn dout(DOUT);
DigitalIn dout2(DOUT2);
DigitalOut gate(GATE);
DigitalOut ck(CK);
DigitalOut range(RANGE);
//
#define SENSITIVITY 1
#define MEASURE 20 //1~1024(ms)の間で変更可能。測定時間は長い方が正確に測定できる。
typedef unsigned short u16;

void getColor();
u16 shiftIn();
u16 rgb[3]={0,0,0};

void getColor(){
    //まず初めにgateとckをLOWにする
    gate = 0;
    ck = 0;
    
    wait_us(2000);
    
    //感度を設定(0:低感度、1:高感度)
    range = SENSITIVITY;
    
    //gateをHIGHにして積算開始(積算中はrangeを変えてはいけない)
    gate = 1;
    wait_ms(MEASURE);
    //gateをLOWにして積算終了
    gate = 0;
    wait_us(4);
    
    rgb[0] = shiftIn();
    rgb[1] = shiftIn();
    rgb[2] = shiftIn();
}

u16 shiftIn(){
    int result = 0;
    for(int i = 0;i < 12;i++){
        ck = 1;
        wait_us(1);
        result |= (dout<<i);
        ck = 0;
        wait_us(1);       
    }
    wait_us(3);
    return result;
}

#endif