/*
This fun example was comleted by JohnnyK / odiin@seznam.cz 5/2018
I am an amateur so this program and web pages are not perfect but working.
In folder ForServer you can found .php files what you can use for control 3 GPIO (on/off) pins and show temperature on the page. For more follow Readme.txt
THX Mbed team and Mbed community and all other who want to help other people be a maker :)

I know Mbed web server is better/faster for gpio control but in my country it is not possible to take advantage of ipv6 without extra cost. Our standart is mixed ipv4/ipv6 but with dynamic and not public IP address.
*/
#include "mbed.h"
#include "DS1820.h"
#include "EthernetInterface.h"

#define SERVER  "server.someweb.com"   // Here you must place your web server address
#define PORT    80                              
#define HOST    "yourweb.com"                   // Here you must place your web domain
#define GPIOPAGE  "gpio.txt"                    // Name of TXT file for GPIO setting
#define TEMPPAGE  "nucleoin.php"                // Name of web page for temperature add/update

DigitalOut gpio[3] = {D8, LED2, LED3};
DigitalOut myled1(LED1);
InterruptIn button(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);
EthernetInterface net;
DS1820  ds1820(A0);
TCPSocket socket;
Timer timer;
Ticker ticker;

float temperature;
int gpioSet[3];
int i;

void liveLed();
void justDoIt();
void connectionStop();
void softReset();

int main() {
    
    pc.printf("Client running...\n");
    // Attach the address of the interrupt handler routine for pushbutton
    button.rise(&softReset);
    // Live led
    ticker.attach(&liveLed, 0.5);
    // Bring up the ethernet interface
    net.connect();
    // Show the network address
    const char *ip = net.get_ip_address();
    // Check ip
    if(ip){ 
        pc.printf("IP address is: %s\n", ip);
    }else{
        pc.printf("No IP");
        // Reset when no IP was detected
        softReset();
    }
    // Begin DS1820
    if(ds1820.begin()) {
        // Start temperature conversion
        ds1820.startConversion();
        // Ĺet DS1820 complete the temperature conversion
        wait(0.5);
    } else {
        pc.printf("No DS1820 sensor found!\r\n");
        // Reset when no sencor was detected
        softReset();
    }
    
    timer.start();
        
    while(1){
        wait(0.5); 
        if(timer > 10){
            pc.printf("Counter: %d\n", i++);
            // Read temperature
            temperature = ds1820.read();
            pc.printf("Temperature = %3.1f\r\n", temperature);
            // Start temperature conversion
            ds1820.startConversion();
            // Call function for temeperature send and request for gpio setting
            justDoIt();
            // Set gpio state for all gpio ports in array
            for(int i = 0; i < 3; i++){
                if (gpio[i].read()!= gpioSet[i]){ 
                    // Set gpio from latest recieved meassege      
                    gpio[i] = gpioSet[i];
                }      
            }
            // Reset Timer
            timer.reset();
        }   
    }  
}

void justDoIt() {
    char sbuffer[100];
    char rbuffer[250];
    char *buffer;
    int scount;
    int rcount;
    //*************************First request*************************  
    // Open a socket on the network interface
    socket.open(&net);
    // Create a TCP connection to server and check of success
    if (socket.connect(SERVER, PORT) < 0) {
        pc.printf("Failed to connect with server\n\r");
        connectionStop();
    }
    // Fill command string into buffer
    sprintf(sbuffer,"GET /%s HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", GPIOPAGE, HOST);
    // Send http request
    scount = socket.send(sbuffer, sizeof sbuffer);
    // Print shorter string of sended messeage
    pc.printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
    // Recieve simple http response
    rcount = socket.recv(rbuffer, sizeof rbuffer);
    // Print out the response
    pc.printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
    // Ignore data from server and take only values after "gpio:" like 1 0 1
    buffer = strstr(rbuffer, "gpio:")+ 5;
    // Extract into int buffer
    sscanf(buffer,"%d %d %d", &gpioSet[0], &gpioSet[1], &gpioSet[2]);
    // Close the socket to return its memory 
    socket.close(); 
    wait(1);
    //*************************Second request*************************
    // Open a socket on the network interface
    socket.open(&net);
    // Create a TCP connection to server and check of success
    if (socket.connect(SERVER, PORT) < 0) {
        pc.printf("Failed to connect with server\n\r");
        connectionStop();
    }
    // Fill command string into buffer
    sprintf(sbuffer,"GET /%s/?temp=%3.1f HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", TEMPPAGE, temperature, HOST );
    // Send http request
    scount = socket.send(sbuffer, sizeof sbuffer);
    pc.printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
    // Recieve http response
    rcount = socket.recv(rbuffer, sizeof rbuffer);
    // Print out the response line
    pc.printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
    // Close the socket to return its memory 
    socket.close();  
}

void connectionStop(){
        // Timer stop
        timer.stop();
        // Close the socket to return its memory 
        socket.close();  
        // Bring down the network interface
        net.disconnect();
        // Mbed reset
        softReset();
}

void softReset(){
        // Wait
        wait(2);
        // Mbed reset
        NVIC_SystemReset();
}

void liveLed(){
    // Change state of Led one
    myled1 =! myled1;
}