#include "mbed.h"
#include "EC.h"
#include "SpeedController.h"
#define RESOLUTION 500
#include "math.h"
#include "R1370P.h"
const double PI=3.141592653589;       //定数


double plot[][2]= {
    {532.41,733.15},
    {532.41,1352.84},
    {541.14,1769.42},
    {523.68,1893.97},
    {610.96,2112.17},
    {680.78,2260.55},
    {785.52,2365.29},
    {925.17,2496.21},
    {1134.64,2583.49},
    {1396.48,2566.03},
    {1911.43,2548.57},
    {2400.20,2531.12},
    {2897.69,2504.93},
    {2966,3000},
    {2966,3500},
    {2966,4000},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {3003.35,4448.60},
    {2498.31,4437.86},
    {1993.28,4384.13},
    {1439.89,4373.39},
    {1241.10,4362.64},
    {993.95,4362.64},
    {805.91,4443.23},
    {714.57,4523.82},
    {607.12,4663.51},
    {505.03,4830.07},
    {462.05,4991.25},
    {499.66,5173.92},
    {569.51,5469.42},
    {687.71,5775.66},
    {907.99,6017.44},
    {1219.61,6205.48},
    {1724.64,6312.94},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {0,0},
    {2546.61,6508.75},
    {1726.41,6396.30},
    {1428.75,6323.54},
    {1131.09,6224.32},
    {939.27,6039.11},
    {800.36,5834.06},
    {615.16,5476.87},
    {549.01,5205.68},
    {496.09,4874.95},
    {489.48,4445.00},
    {515.94,4180.42},
    {522.55,3704.17},
    {588.70,3432.97},
    {787.14,3082.40},
    {985.57,2831.04},
    {1243.54,2617.76},
    {1448.59,2559.84},
    {1699.95,2540.00},
    {2024.06,2506.93},
    {2315.10,2513.54},
    {2447.40,2487.08},
    {2678.91,2361.41},
    {2883.96,2176.20},
    {3069.17,1984.37},
    {3102.24,1686.72},
    {3102.24,1448.59},
    {3055.94,1184.01},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
//{,},
};
int track[3000][2];
int m=0;



DigitalIn button(USER_BUTTON);
DigitalIn tog_(PA_15,PullUp);
DigitalIn slide_(PB_7,PullUp);
DigitalIn tog_lr(PD_2,PullUp);
DigitalIn tog_box(PA_1,PullUp);
DigitalIn tog_stop(PA_0,PullUp);
DigitalIn takt_print(PB_0,PullUp);

SPISlave spi1(PA_7,PA_6,PA_5,PA_4);// mosi, miso, sclk, ssel
//SPISlave spi1(PB_15,PB_14,PB_13,PB_12);// mosi, miso, sclk, ssel

// SPI spi2(PB_15,PB_14,PB_13);
//DigitalOut cs2(PB_12);

Serial pc(USBTX, USBRX);
R1370P gyro(PA_11,PA_12);

Ticker ticker;


////////////////////////////////////////////////////////////////////////////////////////
//(A層,B層,分解能)                         //モータRF
//Ec1multi ec_lf(PC_11,PC_7,RESOLUTION);  //1逓倍用class
//or
Ec2multi ec_lf(PC_11,PC_7,RESOLUTION);  //2逓倍用class
//or
//Ec4multi ec_lf(PC_11,PC_7,RESOLUTION);  //4逓倍用class

//(A層,B層,分解能)                         //モータRB
//Ec1multi ec_rf(PC_6,PC_8,RESOLUTION);  //1逓倍用class
//or
Ec2multi ec_rf(PC_6,PC_8,RESOLUTION);  //2逓倍用class
//or
//Ec4multi ec_rf(PC_6,PC_8,RESOLUTION);  //4逓倍用class

//(A層,B層,分解能)                         //モータLF
//Ec1multi ec_lb(PC_10,PC_12,RESOLUTION);  //1逓倍用class
//or
Ec2multi ec_lb(PC_10,PC_12,RESOLUTION);  //2逓倍用class
//or
//Ec4multi ec_lb(PC_10,PC_12,RESOLUTION);  //4逓倍用class

//(A層,B層,分解能)                         //モータLB
//Ec1multi ec_rb(PC_5,PC_9,RESOLUTION);  //1逓倍用class
//or
Ec2multi ec_rb(PC_5,PC_9,RESOLUTION);  //2逓倍用class
//or
//Ec4multi ec_rb(PC_5,PC_9,RESOLUTION);  //4逓倍用class


SpeedControl motor_lf(PB_5,PB_4,50,ec_lf);
SpeedControl motor_rf(PB_3,PA_10,50,ec_rf);
SpeedControl motor_lb(PB_10,PA_8,50,ec_lb);
SpeedControl motor_rb(PA_9,PB_6,50,ec_rb);
////////////////////////////////////////////////////////////////
double x=0,y=0,angle=0;
int stage_select=1;        //ステージ左右選択
double angle_rad=0 ;       //弧度法表示
//変数angle_old, 関数calDirect, 定数 MI,  クラス名:SpeedControl
double delta_t=0.05;

int n=0,destination=0;

////////////////////////////////////////////////////////
double ex=0,ey=0;
void calDirect()          //     進行方向の計算
{
    ex=plot[n][0]-plot[n-1][0];
    ey=plot[n][1]-plot[n-1][1];
    ex=stage_select*ex;  //ステージ左右の反映
    ex=ex/sqrt(ex*ex+ey*ey);
    ey=ey/sqrt(ex*ex+ey*ey);
}
/////////////////////////////////////////////////////////////////移動速度計算用
double speed=0;
double speed_max=20;
double dist_speed=0,dist_old=0,i_speed=0;
double kp_speed=0.15,ki_speed=0,kd_speed=0;
Timer timer;
double brake=0;
void calSpeed()
{
    dist_speed=(plot[destination][0]-x)*(plot[destination][0]-x)+(plot[destination][1]-y)*(plot[destination][1]-y);
    dist_speed=sqrt(dist_speed);
    i_speed=(dist_speed+dist_old)*delta_t/2;
    double d_speed=(dist_old-dist_speed)/delta_t;
    speed=kp_speed*dist_speed+ki_speed*i_speed-kd_speed*d_speed;

    if(speed>speed_max) {
        speed=speed_max;
    }
    if(brake<speed_max) {
        brake=5*timer.read();
        speed=brake;
    }
    dist_old=dist_speed;

}
void setSpeed(double s)
{
    speed=s;

}
//////////////////////////////////////////////////////////////////回転速度計算
double v_omega=0;
double angle_start=0,target_angle=0;
double omega_max=15;
double angle_old=0,i_omega=0;
double kp_omega=0.4,ki_omega=0,kd_omega=0;
void calomega()
{
    double p_omega=target_angle-angle;
    i_omega=i_omega+((2*target_angle-angle-angle_old)*delta_t/2);
    double d_omega=(angle-angle_old)/delta_t;

    v_omega=kp_omega*p_omega+ki_omega*i_omega-kd_omega*d_omega;

    if(v_omega>omega_max) {
        v_omega=omega_max;
    } else if(v_omega<-omega_max) {
        v_omega=-omega_max;
    }
}
///////////////////////////////////////////////////////////////////経路復帰速度計算
double diff=0;
double diff_speed=0;
double diff_max=10;
double diff_old=0,i_diff=0;
double kp_diff=0.04,ki_diff=0,kd_diff=0;
void calDiff()                  //目標直線とのずれを計算
{
    double x_d=0,y_d=0,diff=0;
    x_d=x-plot[n-1][0];
    y_d=y-plot[n-1][1];
    diff=x_d*ey-y_d*ex;
    i_diff=(diff+diff_old)*delta_t/2;
    double d_diff=(diff_old-diff)/delta_t;
    diff_speed=kp_diff*diff+ki_diff*i_diff-kd_diff*d_diff;

    if(diff>diff_max) {
        diff=diff_max;
    } else if(diff<-diff_max) {
        diff=-diff_max;
    }
    diff_old=diff;
}
////////////////////////////////////////////////////////////////////////////////
double v_rf=0,v_rb=0,v_lf=0,v_lb=0;            //速度計算用
double v_x=0,v_y=0;
double k_ff=0;
void calVelocity()     //               tickerでまわす。速度、各モータ速度の決定
{
    v_x=speed*ex-diff_speed*ey;
    v_y=speed*ey+diff_speed*ex;

    angle_rad=PI*angle/180;
    v_rf=v_y*sin(PI/4-angle_rad)+v_x*cos(PI/4-angle_rad)+v_omega;
    v_rb=v_y*sin(3*PI/4-angle_rad)+v_x*cos(3*PI/4-angle_rad)+v_omega;
    v_lf=v_y*sin(-PI/4-angle_rad)+v_x*cos(-PI/4-angle_rad)+v_omega;
    v_lb=v_y*sin(-3*PI/4-angle_rad)+v_x*cos(-3*PI/4-angle_rad)+v_omega;

}
void Trace()
{
    x=x+k_ff*v_x;
    y=y+k_ff*v_y;
    calomega();
    calDiff();
    calVelocity();
    motor_rf.Sc(v_rf);
    motor_rb.Sc(v_rb);
    motor_lf.Sc(v_lf);
    motor_lb.Sc(v_lb);
}
void pointAdjust()
{
    calomega();
    calSpeed();
    calDiff();
    calVelocity();
    motor_rf.Sc(v_rf);
    motor_rb.Sc(v_rb);
    motor_lf.Sc(v_lf);
    motor_lb.Sc(v_lb);
}
////////////////////////////////////////////////////////////////////////
double fast=20,slow=10;
void Judge()                                                //通過判定と通過後の各設定
{

    double judge;
    double x_d=0,y_d=0;
    x_d=plot[n][0]-x;
    y_d=plot[n][1]-y;
    judge=ex*x_d+ey*y_d;

    if(judge<0) {
        n++;
        printf("n= %d \r\n",n);
        calDirect();
        if(n==4) {
            target_angle=0.00;
            setSpeed(10);
        } else if(n==11&&tog_box==1) {//箱が奥にあるとき
            setSpeed(35);
        } else if(n==12&&tog_box==0) {//箱が手前にある時(n=14からの座標を調整し、n=14にする）

            n=14;
        } else if(n==13) {
            setSpeed(10);
        } else if(n==17) {
            target_angle=90.00;
            setSpeed(10);
            if(tog_box==1) { //アーム完成後この辺調整するのでそれまで
                n=21;
            } else {
                n=23;
            }
        } else if(n==22) {
            setSpeed(35);
        } else if(n==24) {
            setSpeed(35);
        } else if(n==26) {
            setSpeed(10);
        } else if(n==33) {
            setSpeed(35);
        } else if(n==38) {
            setSpeed(10);
            n=51;          //箱を置くタスクを増設する予定のｎを飛ばす
        } else if(n==52) {
            target_angle=0.00;
            setSpeed(35);
        } else if(n==58) {
            setSpeed(10);
        } else if(n==60) {
            setSpeed(35);
        } else if(n==67) {
            setSpeed(10);
        } else if(n==70) {
            setSpeed(35);
        } else if(n==74) {
            setSpeed(10);
        } else if(n==77) {
            setSpeed(35);
        }
    }

}
////////////////////////////////////////////////////////////////////////////
void modeSwitch()
{
    if(tog_lr==0) {
        stage_select=-1;
        printf("Left Stage\r\n");
        if(tog_box==0) {
            spi1.reply(1);//7セグ0
            plot[14][0]=plot[14][0]-928;
            plot[15][0]=plot[15][0]-928;
            plot[16][0]=plot[16][0]-928;
            printf("Box is left\r\n");
        } else {
            spi1.reply(3);//7セグ2
            printf("Box is Right\r\n");
        }
    } else {
        stage_select=1;
        printf("Right Stage\r\n");
        if(tog_box==0) {
            spi1.reply(2);//7セグ1
            plot[14][0]=plot[14][0]-928;
            plot[15][0]=plot[15][0]-928;
            plot[16][0]=plot[16][0]-928;
            printf("Box is Right\r\n");
        } else {
            spi1.reply(4);//7セグ3
            printf("Box is left\r\n");
        }
    }


}

//////////////////////////////////////停止後にプリント
int printer=1;
void trackPrint()
{
    motor_rf.stop();
    motor_rb.stop();
    motor_lf.stop();
    motor_lb.stop();
    ticker.detach();
    printf("print start\r\n");
    int i=0;
    while(track[i][0]!=0 && track[i][1]!=0) {
        printf("%d\t%d\r\n",track[i][0],track[i][1]);
        i++;
    }
    printf("print finish\r\n");
}

int main()
{

    motor_rf.setEquation(0.007073,0.008549,-0.007020,0.007291);  //求めたC,Dの値を設定
    motor_rb.setEquation(0.006972,0.017836,-0.006900,0.021584);  //求めたC,Dの値を設定
    motor_lf.setEquation(0.006778,0.009135,-0.006845,0.005547);   //求めたC,Dの値を設定
    motor_lb.setEquation(0.006927,0.010144,-0.006984,0.010782);  //求めたC,Dの値を設定
    motor_rf.setPDparam(0.095,0.0028);  //PIDの係数を設定//
    motor_rb.setPDparam(0.079,0.0021);  //PIDの係数を設定//
    motor_lf.setPDparam(0.114,0.0014);  //PIDの係数を設定//
    motor_lb.setPDparam(0.098,0.0015);  //PIDの係数を設定//
    motor_rf.setDutyLimit(0.5);
    motor_rb.setDutyLimit(0.5);
    motor_lf.setDutyLimit(0.5);
    motor_lb.setDutyLimit(0.5);

    gyro.initialize();

    spi1.format(16,3);
    spi1.frequency(1000000);
    spi1.reply(0);


//    while(button==1) {
//        printf("READY!!\r\n");
//        wait(1);
//    }

    while(1) {
        if(spi1.receive()) {
            angle=gyro.getAngle();
            angle=angle-angle_start;
            angle=stage_select*angle;

            int reply=0;
            if(angle>=0) {
                reply=10*angle;
                reply=reply<<2;
                reply++;
            } else {
                reply=-10*angle;
                reply=reply<<2;

            }


            int data=spi1.read();
            //////////////////////////////////リセット
            if(data==0b1111111111111111) {
                motor_rf.stop();
                motor_rb.stop();
                motor_lf.stop();
                motor_lb.stop();
                ticker.detach();
                printf("/////////////////  Reset  ///////////////////////\r\n");
                n=0;

                angle_start=gyro.getAngle();
                modeSwitch();
            } else if(data==0b0000000000000000) {
                printf("Error\r\n");
            }
            ////////////////////////////////自動
            else if(data&1) {
                data=data>>1;
                if(data&1) {
                    x=data>>1;
                    spi1.reply(reply);
                } else {
                    y=data>>1;
                    reply=reply+0b10;
                    spi1.reply(reply);
                }
                if(tog_stop==0) {
                    motor_rf.stop();
                    motor_rb.stop();
                    motor_lf.stop();
                    motor_lb.stop();
                    ticker.detach();
                    printf("STOP\r\n");
                    printf("(\t%f\t%f\t)\t%f\r\n",x,y,angle);
                    wait(1);
                } else {

                    if(n==0) {
                        n=1;
                        target_angle=0.00;
                        calDirect();
                        setSpeed(35);
                        ticker.attach(&Trace,delta_t);
                    } else if(n>=1&&n<=13) {
                        Judge();

                    } else if(n==14) {


                    } else if(n>=10&&n<=18) {
                        Judge();


                    } else if(n>=19&&n<=24) {
                        Judge();


                    } else if(n>=25&&n<=27) {
                        Judge();


                    } else if(n>=28&&n<=32) {
                        Judge();


                    } else if(n>=33&&n<=37) {
                        Judge();


                    } else if(n>=38&&n<=42) {
                        Judge();


                    } else if(n>=43&&n<=46) {
                        Judge();


                    } else if(n>=47&&n<=48) {
                        Judge();


                    } else if(n>=49&&n<=53) {
                        Judge();


                    }

                    if(n==54) {
                        motor_rf.stop();
                        motor_rb.stop();
                        motor_lf.stop();
                        motor_lb.stop();
                        ticker.detach();
                        printf("Finish\r\n");
                    }

                }
            }
            printer++;
            if(printer>1000) {
                track[m][0]=x;
                track[m][1]=y;
                printer=0;
                m++;
            }
            if(takt_print==0) {
                trackPrint();
            }
        }
        ///////////////////////////////手動
        else {

        }
/////////////////////////////////////////////////////////



    }
}
