#include "mbed.h"
#include "EC.h" //Encoderライブラリをインクルード
#include "SpeedController.h"    //SpeedControlライブラリをインクルード
#define RESOLUTION 500
///////////////////////////////////////////////////////////////////////
PwmOut rotPL(PA_11);             //motor(3)1 射出用
PwmOut rotNL(PB_15);
PwmOut rotPR(PC_9);            //motor(1)2 シリンダー用
PwmOut rotNR(PC_8);
DigitalIn toggle1(PA_15,PullUp);
DigitalIn toggle2(PB_7,PullUp);
DigitalIn blue_button(USER_BUTTON,PullUp);

Ec2multi EC_mR(PC_10,PC_12,2048);//基盤左上 シリンダー用
SpeedControl motorR(PC_8,PC_9,50,EC_mR);

Ec2multi EC_mL(PC_3,PC_2,500);//基盤2連結上 射出用
SpeedControl motorL(PA_11,PB_15,50,EC_mL);
/////////////////////////////////////////////////////////////////////////
/*川間の基板用
PwmOut rotPL(PB_3);             //motor(3)1 射出用
PwmOut rotNL(PB_13);
PwmOut rotPR(PB_15);            //motor(1)2 シリンダー用
PwmOut rotNR(PB_14);
DigitalIn toggle1(PC_5,PullUp);
DigitalIn blue_button(USER_BUTTON,PullUp);


Ec2multi EC_mR(PC_10,PC_12,2048);//基盤左上 シリンダー用
SpeedControl motorR(PB_15,PB_14,50,EC_mR);

Ec2multi EC_mL(PC_3,PC_2,500);//基盤2連結上 射出用
SpeedControl motorL(PB_3,PB_13,50,EC_mL);*/
///////////////////////////////////////////////////////////////////////////

double degR,deg;
double target_deg;
double x=56.8; //角度の初期値
double t,pre_t;

void angle_adj(double target_deg);

int main()
{
    //motorR.setEquation(0.005235,-0.034197,0,0);   //求めたC,Dの値を設定,RZ
    //motorR.setPDparam(0.008056,0.01744);  //PDの係数を設定.リポバッテリー.RZ
    //motorR.setPDparam(0.012056,0.01644);//定格電源.RZ
    //motorR.setEquation(0.003304,-0.022279,0,0);//775
    //motorR.setPDparam(0.008056,0.01744); //775.リポバッテリー
    //motorR.setPDparam(0.009556,0.01854);//775.定格電源


    motorL.setEquation(0.003304,-0.022279,0,0);//775
    //motorL.setPIDparam(0.01,0,0); //775.リポバッテリー
    //motorL.setPDIparam(0.0058,0,0.00521257413);//775.定格電源 omega=122
    //motorL.setPIDparam(0.03,0.0083,0.03450413);//775.定格電源 omega=120 
    motorL.setPIDparam(0.03,0.06,0.0657413);//775.定格電源 omega=130 
    //motorL.setPIDparam(0.028,0.097,0.095413);//omega=145
    //motorL.setPIDparam(0.03,0.04,0.04817413);//775.定格電源 omega=140 6秒
    //motorL.setPIDparam(0,0,0);
    //motorL.setPIDparam(0.000384225,0.002309477,0.000016 );
    
    rotPR.period_us(50);
    rotNR.period_us(50);
    
    motorL.period_us(50);
    motorR.period_us(50);
    motorL.setDutyLimit(0.90);
    motorR.setDutyLimit(0.90);
    
    int kai=0;

    double OmegaL;

    printf("time[s]\tomegaR\tomegaL\tdutyR\tdutyL\r\n");

    while(1) {
        OmegaL=EC_mL.getOmega();
        //OmegaR=EC_mR.getOmega();
        double countR=EC_mR.getCount(); 
        //countL=EC_mL.getCount();
        
        degR=countR*360/(2048*2);//角度計算(要検証)
        deg=x+degR;

        if(toggle1==1) {
            motorR.stop();
            motorL.stop();
            //printf("waiting...\r\n");
        }

        else {
            //motorL.Sc(130);//目標角速度を設定
            //50度
            //
            motorL.turn(0.45);
            //rotPL=0.1;
            wait(0.05);
            kai++;

            if(kai>0) {

                printf("%f\t%f\r\n",EC_mL.timer_.read(),OmegaL);
                kai=0;
            }
        }

        if(blue_button==0) {//押し続ける
            angle_adj(54);//目標角度を設定
            //55度は精度よさげ
        } else {
            t=0;
            pre_t=0;
            rotPR=0;
            rotNR=0;
        }
    }
}

void angle_adj(double target_deg)
{
    t=EC_mR.timer_.read();
    double diff= deg-target_deg;
    if(diff<=0){
        rotPR=0.5;
        rotNR=0;
    } else {
        rotPR=0;
        rotNR=0.5;
        }
    if(deg==target_deg){
        rotPR=0;
        rotNR=0;
        }
    printf("%f\t%f\t%f\r\n",t,degR,deg);
}
/*
void angle_adj(double target_deg)
{
    t=EC_mR.timer_.read();
    double Kp,Kd;
    Kp=0.027;
    Kd=0;
    double diff= deg-target_deg;
    double delta_e=diff/(t-pre_t);
    double pd = ( Kp*diff +  Kd*delta_e );
    double duty=pd;
    if(duty<0) {
        duty=-1*duty;
    }
    if(duty>0.95) {
        duty=0.95;
    }else if(duty<0.3) {
        duty=0.3;
    }
    if(diff<=0) {
        rotPR=duty;
    } else {
        rotNR=duty;
    }
    pre_t=t;
    printf("%f\t%f\t%f\t%f\r\n",t,degR,deg,duty);
}*/