/* mbed Microcontroller Library - SerialHalfDuplex
 * Copyright (c) 2010-2011 ARM Limited. All rights reserved.
 * written and changed by Hiroki Mineshita at 2016-04-12
 * by https://github.com/mbedmicro/mbed/tree/master/libraries/tests/libs/SerialHalfDuplex
 */
#include "SerialHalfDuplex.h"

#if DEVICE_SERIAL

namespace mbed {

SerialHalfDuplex::SerialHalfDuplex(PinName tx, PinName rx,const char *name)
    : Serial(tx,rx,name) {
}

int SerialHalfDuplex::_putc(int c) {
    int retc;
    Serial::_putc(c);
    if(Serial::readable())retc = Serial::getc();       // reading also clears any interrupt
    else retc=-1000;
    return retc;
}

int SerialHalfDuplex::_getc(void) {
    if(Serial::readable()) return Serial::_getc();
    else return -1000;
}

} // End namespace

#endif